/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import org.opennms.netmgt.bsm.persistence.api.functions.map.AbstractMapFunctionEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.DecreaseEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.IdentityEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.IgnoreEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.IncreaseEntity;
import org.opennms.netmgt.bsm.persistence.api.functions.map.MapFunctionEntityVisitor;
import org.opennms.netmgt.bsm.persistence.api.functions.map.SetToEntity;
import org.opennms.netmgt.bsm.service.internal.SeverityMapper;
import org.opennms.netmgt.bsm.service.model.functions.map.Decrease;
import org.opennms.netmgt.bsm.service.model.functions.map.Identity;
import org.opennms.netmgt.bsm.service.model.functions.map.Ignore;
import org.opennms.netmgt.bsm.service.model.functions.map.Increase;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunctionVisitor;
import org.opennms.netmgt.bsm.service.model.functions.map.SetTo;

public class MapFunctionMapper {
    private static final MapFunctionVisitor<AbstractMapFunctionEntity> serviceToPersistenceMapping = new MapFunctionVisitor<AbstractMapFunctionEntity>(){

        public AbstractMapFunctionEntity visit(Decrease decrease) {
            return new DecreaseEntity();
        }

        public AbstractMapFunctionEntity visit(Identity identity) {
            return new IdentityEntity();
        }

        public AbstractMapFunctionEntity visit(Ignore ignore) {
            return new IgnoreEntity();
        }

        public AbstractMapFunctionEntity visit(Increase increase) {
            return new IncreaseEntity();
        }

        public AbstractMapFunctionEntity visit(SetTo setTo) {
            SetToEntity entity = new SetToEntity();
            entity.setSeverity(SeverityMapper.toSeverity(setTo.getStatus()));
            return entity;
        }
    };
    private static final MapFunctionEntityVisitor<MapFunction> persistenceToServiceMapping = new MapFunctionEntityVisitor<MapFunction>(){

        public MapFunction visit(DecreaseEntity decreaseEntity) {
            return new Decrease();
        }

        public MapFunction visit(IdentityEntity identityEntity) {
            return new Identity();
        }

        public MapFunction visit(IgnoreEntity ignoreEntity) {
            return new Ignore();
        }

        public MapFunction visit(IncreaseEntity increaseEntity) {
            return new Increase();
        }

        public MapFunction visit(SetToEntity setToEntity) {
            SetTo result = new SetTo();
            result.setStatus(SeverityMapper.toStatus(setToEntity.getSeverity()));
            return result;
        }
    };

    public AbstractMapFunctionEntity toPersistenceFunction(MapFunction mapFunction) {
        AbstractMapFunctionEntity mapFunctionEntity = (AbstractMapFunctionEntity)mapFunction.accept(serviceToPersistenceMapping);
        if (mapFunctionEntity == null) {
            throw new IllegalArgumentException("No mapping found");
        }
        return mapFunctionEntity;
    }

    public MapFunction toServiceFunction(AbstractMapFunctionEntity mapFunctionEntity) {
        if (mapFunctionEntity == null) {
            return null;
        }
        MapFunction mapFunction = (MapFunction)mapFunctionEntity.accept(persistenceToServiceMapping);
        if (mapFunction == null) {
            throw new IllegalArgumentException("No mapping found");
        }
        return mapFunction;
    }
}

