/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.amqp.eventforwarder;

import com.google.common.base.Preconditions;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingEventListener
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingEventListener.class);
    private volatile EventForwarder eventForwarder;
    private volatile EventIpcManager eventIpcManager;

    public EventForwarder getEventForwarder() {
        return this.eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public EventIpcManager getEventIpcManager() {
        return this.eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.eventIpcManager = eventIpcManager;
    }

    public void init() {
        Preconditions.checkNotNull((Object)this.eventIpcManager, (Object)"eventIpcManager must not be null");
        Preconditions.checkNotNull((Object)this.eventForwarder, (Object)"eventForwarder must not be null");
        this.eventIpcManager.addEventListener((EventListener)this);
    }

    public void destroy() {
        if (this.eventIpcManager != null) {
            this.eventIpcManager.removeEventListener((EventListener)this);
        }
    }

    public void onEvent(Event event) {
        LOG.debug("Forwarding event with uei: {}", (Object)event.getUei());
        this.eventForwarder.sendNow(event);
    }

    public String getName() {
        return "AMQPEventForwarder";
    }
}

