/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.amqp.alarmnorthbounder;

import java.util.List;
import org.opennms.features.amqp.alarmnorthbounder.internal.DefaultAlarmForwarder;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmNorthbounder
extends AbstractNorthbounder {
    private volatile DefaultAlarmForwarder alarmForwarder;
    private static final Logger LOG = LoggerFactory.getLogger(AlarmNorthbounder.class);

    public AlarmNorthbounder() {
        super("AMQPNorthbounder");
        LOG.debug("AMQPNorthbounder created");
    }

    protected boolean accepts(NorthboundAlarm alarm) {
        return true;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        for (NorthboundAlarm alarm : alarms) {
            LOG.trace("AMQPNorthbounder Forwarding alarm: {}", (Object)alarm);
            this.alarmForwarder.sendNow(alarm);
        }
    }

    public DefaultAlarmForwarder getAlarmForwarder() {
        return this.alarmForwarder;
    }

    public void setAlarmForwarder(DefaultAlarmForwarder alarmForwarder) {
        this.alarmForwarder = alarmForwarder;
    }
}

