/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools.config;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.drools.ConfigFileApplicationContext;
import org.opennms.netmgt.correlation.drools.DroolsCorrelationEngine;
import org.opennms.netmgt.correlation.drools.config.Global;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="rule-set")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RuleSet
implements Serializable {
    @XmlAttribute(name="name")
    private String _name;
    @XmlAttribute(name="assert-behaviour")
    private String _assertBehaviour;
    @XmlElement(name="rule-file")
    private List<String> _ruleFileList = new ArrayList<String>();
    @XmlElement(name="event")
    private List<String> _eventList = new ArrayList<String>();
    @XmlElement(name="app-context")
    private String _appContext;
    @XmlElement(name="global")
    private List<Global> _globalList = new ArrayList<Global>();

    public String getAssertBehaviour() {
        return this._assertBehaviour == null ? "identity" : this._assertBehaviour;
    }

    public void setAssertBehaviour(String assertBehaviour) {
        this._assertBehaviour = assertBehaviour;
    }

    public void addEvent(String vEvent) throws IndexOutOfBoundsException {
        this._eventList.add(vEvent);
    }

    public void addEvent(int index, String vEvent) throws IndexOutOfBoundsException {
        this._eventList.add(index, vEvent);
    }

    public void addGlobal(Global vGlobal) throws IndexOutOfBoundsException {
        this._globalList.add(vGlobal);
    }

    public void addGlobal(int index, Global vGlobal) throws IndexOutOfBoundsException {
        this._globalList.add(index, vGlobal);
    }

    public void addRuleFile(String vRuleFile) throws IndexOutOfBoundsException {
        this._ruleFileList.add(vRuleFile);
    }

    public void addRuleFile(int index, String vRuleFile) throws IndexOutOfBoundsException {
        this._ruleFileList.add(index, vRuleFile);
    }

    public Enumeration<String> enumerateEvent() {
        return Collections.enumeration(this._eventList);
    }

    public Enumeration<Global> enumerateGlobal() {
        return Collections.enumeration(this._globalList);
    }

    public Enumeration<String> enumerateRuleFile() {
        return Collections.enumeration(this._ruleFileList);
    }

    public String getAppContext() {
        return this._appContext;
    }

    public String getEvent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._eventList.size()) {
            throw new IndexOutOfBoundsException("getEvent: Index value '" + index + "' not in range [0.." + (this._eventList.size() - 1) + "]");
        }
        return this._eventList.get(index);
    }

    public String[] getEvent() {
        String[] array = new String[]{};
        return this._eventList.toArray(array);
    }

    public List<String> getEventCollection() {
        return this._eventList;
    }

    public int getEventCount() {
        return this._eventList.size();
    }

    public Global getGlobal(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._globalList.size()) {
            throw new IndexOutOfBoundsException("getGlobal: Index value '" + index + "' not in range [0.." + (this._globalList.size() - 1) + "]");
        }
        return this._globalList.get(index);
    }

    public Global[] getGlobal() {
        Global[] array = new Global[]{};
        return this._globalList.toArray(array);
    }

    public List<Global> getGlobalCollection() {
        return this._globalList;
    }

    public int getGlobalCount() {
        return this._globalList.size();
    }

    public String getName() {
        return this._name;
    }

    public String getRuleFile(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ruleFileList.size()) {
            throw new IndexOutOfBoundsException("getRuleFile: Index value '" + index + "' not in range [0.." + (this._ruleFileList.size() - 1) + "]");
        }
        return this._ruleFileList.get(index);
    }

    public String[] getRuleFile() {
        String[] array = new String[]{};
        return this._ruleFileList.toArray(array);
    }

    public List<String> getRuleFileCollection() {
        return this._ruleFileList;
    }

    public int getRuleFileCount() {
        return this._ruleFileList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateEvent() {
        return this._eventList.iterator();
    }

    public Iterator<Global> iterateGlobal() {
        return this._globalList.iterator();
    }

    public Iterator<String> iterateRuleFile() {
        return this._ruleFileList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllEvent() {
        this._eventList.clear();
    }

    public void removeAllGlobal() {
        this._globalList.clear();
    }

    public void removeAllRuleFile() {
        this._ruleFileList.clear();
    }

    public boolean removeEvent(String vEvent) {
        boolean removed = this._eventList.remove(vEvent);
        return removed;
    }

    public String removeEventAt(int index) {
        String obj = this._eventList.remove(index);
        return obj;
    }

    public boolean removeGlobal(Global vGlobal) {
        boolean removed = this._globalList.remove(vGlobal);
        return removed;
    }

    public Global removeGlobalAt(int index) {
        Global obj = this._globalList.remove(index);
        return obj;
    }

    public boolean removeRuleFile(String vRuleFile) {
        boolean removed = this._ruleFileList.remove(vRuleFile);
        return removed;
    }

    public String removeRuleFileAt(int index) {
        String obj = this._ruleFileList.remove(index);
        return obj;
    }

    public void setAppContext(String appContext) {
        this._appContext = appContext;
    }

    public void setEvent(int index, String vEvent) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._eventList.size()) {
            throw new IndexOutOfBoundsException("setEvent: Index value '" + index + "' not in range [0.." + (this._eventList.size() - 1) + "]");
        }
        this._eventList.set(index, vEvent);
    }

    public void setEvent(String[] vEventArray) {
        this._eventList.clear();
        for (int i = 0; i < vEventArray.length; ++i) {
            this._eventList.add(vEventArray[i]);
        }
    }

    public void setEvent(List<String> vEventList) {
        this._eventList.clear();
        this._eventList.addAll(vEventList);
    }

    public void setEventCollection(List<String> eventList) {
        this._eventList = eventList;
    }

    public void setGlobal(int index, Global vGlobal) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._globalList.size()) {
            throw new IndexOutOfBoundsException("setGlobal: Index value '" + index + "' not in range [0.." + (this._globalList.size() - 1) + "]");
        }
        this._globalList.set(index, vGlobal);
    }

    public void setGlobal(Global[] vGlobalArray) {
        this._globalList.clear();
        for (int i = 0; i < vGlobalArray.length; ++i) {
            this._globalList.add(vGlobalArray[i]);
        }
    }

    public void setGlobal(List<Global> vGlobalList) {
        this._globalList.clear();
        this._globalList.addAll(vGlobalList);
    }

    public void setGlobalCollection(List<Global> globalList) {
        this._globalList = globalList;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRuleFile(int index, String vRuleFile) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ruleFileList.size()) {
            throw new IndexOutOfBoundsException("setRuleFile: Index value '" + index + "' not in range [0.." + (this._ruleFileList.size() - 1) + "]");
        }
        this._ruleFileList.set(index, vRuleFile);
    }

    public void setRuleFile(String[] vRuleFileArray) {
        this._ruleFileList.clear();
        for (int i = 0; i < vRuleFileArray.length; ++i) {
            this._ruleFileList.add(vRuleFileArray[i]);
        }
    }

    public void setRuleFile(List<String> vRuleFileList) {
        this._ruleFileList.clear();
        this._ruleFileList.addAll(vRuleFileList);
    }

    public void setRuleFileCollection(List<String> ruleFileList) {
        this._ruleFileList = ruleFileList;
    }

    public static RuleSet unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (RuleSet)Unmarshaller.unmarshal(RuleSet.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._appContext == null ? 0 : this._appContext.hashCode());
        result = 31 * result + (this._eventList == null ? 0 : this._eventList.hashCode());
        result = 31 * result + (this._globalList == null ? 0 : this._globalList.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._ruleFileList == null ? 0 : this._ruleFileList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleSet other = (RuleSet)obj;
        if (this._appContext == null ? other._appContext != null : !this._appContext.equals(other._appContext)) {
            return false;
        }
        if (this._eventList == null ? other._eventList != null : !this._eventList.equals(other._eventList)) {
            return false;
        }
        if (this._globalList == null ? other._globalList != null : !this._globalList.equals(other._globalList)) {
            return false;
        }
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        return !(this._ruleFileList == null ? other._ruleFileList != null : !this._ruleFileList.equals(other._ruleFileList));
    }

    public CorrelationEngine constructEngine(Resource basePath, ApplicationContext appContext, EventIpcManager eventIpcManager) {
        ConfigFileApplicationContext configContext = new ConfigFileApplicationContext(basePath, this.getConfigLocation(), appContext);
        DroolsCorrelationEngine engine = new DroolsCorrelationEngine();
        engine.setName(this.getName());
        engine.setAssertBehaviour(this.getAssertBehaviour());
        engine.setEventIpcManager(eventIpcManager);
        engine.setScheduler(new Timer(this.getName() + "-Timer"));
        engine.setInterestingEvents(this.getInterestingEvents());
        engine.setRulesResources(this.getRuleResources((ResourceLoader)configContext));
        engine.setGlobals(this.getGlobals((ApplicationContext)configContext));
        try {
            engine.initialize();
            return engine;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to initialize Drools engine " + this.getName(), e);
        }
    }

    public Map<String, Object> getGlobals(ApplicationContext context) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        for (Global global : this.getGlobal()) {
            globals.put(global.getName(), global.constructValue(context));
        }
        return globals;
    }

    public List<String> getInterestingEvents() {
        return Arrays.asList(this.getEvent());
    }

    public Resource getResource(ResourceLoader resourceLoader, String resourcePath) {
        return resourceLoader.getResource(PropertiesUtils.substitute((String)resourcePath, (Properties[])new Properties[]{System.getProperties()}));
    }

    public List<Resource> getRuleResources(ResourceLoader resourceLoader) {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        for (String resourcePath : this.getRuleFile()) {
            resources.add(this.getResource(resourceLoader, resourcePath));
        }
        return resources;
    }

    public String getConfigLocation() {
        return PropertiesUtils.substitute((String)this.getAppContext(), (Properties[])new Properties[]{System.getProperties()});
    }
}

