/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.correlation.AbstractCorrelationEngine;
import org.opennms.netmgt.correlation.drools.TimerExpired;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.core.io.Resource;

public class DroolsCorrelationEngine
extends AbstractCorrelationEngine {
    private WorkingMemory m_workingMemory;
    private List<String> m_interestingEvents;
    private List<Resource> m_rules;
    private Map<String, Object> m_globals = new HashMap<String, Object>();
    private String m_name;

    public synchronized void correlate(Event e) {
        LogUtils.debugf((Object)((Object)this), (String)"Begin correlation for Event %d uei: %s", (Object[])new Object[]{e.getDbid(), e.getUei()});
        this.m_workingMemory.insert((Object)e);
        this.m_workingMemory.fireAllRules();
        LogUtils.debugf((Object)((Object)this), (String)"End correlation for Event %d uei: %s", (Object[])new Object[]{e.getDbid(), e.getUei()});
    }

    protected synchronized void timerExpired(Integer timerId) {
        LogUtils.infof((Object)((Object)this), (String)"Begin correlation for Timer %d", (Object[])new Object[]{timerId});
        TimerExpired expiration = new TimerExpired(timerId);
        this.m_workingMemory.insert((Object)expiration);
        this.m_workingMemory.fireAllRules();
        LogUtils.debugf((Object)((Object)this), (String)"Begin correlation for Timer %d", (Object[])new Object[]{timerId});
    }

    public List<String> getInterestingEvents() {
        return this.m_interestingEvents;
    }

    public void setInterestingEvents(List<String> ueis) {
        this.m_interestingEvents = ueis;
    }

    public void setRulesResources(List<Resource> rules) {
        this.m_rules = rules;
    }

    public void setGlobals(Map<String, Object> globals) {
        this.m_globals = globals;
    }

    public void initialize() throws Exception {
        Properties props = new Properties();
        props.setProperty("drools.dialect.java.compiler.lnglevel", "1.6");
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration(props);
        PackageBuilder builder = new PackageBuilder(conf);
        this.loadRules(builder);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        this.m_workingMemory = ruleBase.newStatefulSession();
        this.m_workingMemory.setGlobal("engine", (Object)this);
        for (Map.Entry<String, Object> entry : this.m_globals.entrySet()) {
            this.m_workingMemory.setGlobal(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRules(PackageBuilder builder) throws DroolsParserException, IOException {
        for (Resource rulesFile : this.m_rules) {
            InputStreamReader rdr = null;
            try {
                rdr = new InputStreamReader(rulesFile.getInputStream(), "UTF-8");
                builder.addPackageFromDrl((Reader)rdr);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(rdr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)rdr);
        }
    }

    public int getMemorySize() {
        int count = 0;
        Iterator it = this.m_workingMemory.iterateObjects();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    public List<Object> getMemoryObjects() {
        LinkedList<Object> objects = new LinkedList<Object>();
        Iterator it = this.m_workingMemory.iterateObjects();
        while (it.hasNext()) {
            it.next();
        }
        return objects;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setGlobal(String name, Object value) {
        this.m_workingMemory.setGlobal(name, value);
    }
}

