/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import java.io.IOException;
import org.opennms.core.utils.LogUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class ConfigFileApplicationContext
extends AbstractXmlApplicationContext {
    private Resource m_resource;
    private String m_configFileLocation;

    public ConfigFileApplicationContext(Resource basePath, String configFileLocation, ApplicationContext parent) {
        super(parent);
        this.m_resource = basePath;
        this.m_configFileLocation = configFileLocation;
        this.refresh();
    }

    protected String[] getConfigLocations() {
        if (this.m_configFileLocation == null) {
            return null;
        }
        return new String[]{this.m_configFileLocation};
    }

    protected Resource getResourceByPath(String path) {
        try {
            return this.m_resource.createRelative(path);
        }
        catch (IOException e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"Unable to create resource for path %s relative the directory of %s", (Object[])new Object[]{path, this.m_resource});
            throw new IllegalArgumentException("Failed to create relative path for " + path);
        }
    }
}

