/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.correlation.CorrelationEngine;
import org.opennms.netmgt.correlation.CorrelationEngineRegistrar;
import org.opennms.netmgt.correlation.drools.ConfigFileApplicationContext;
import org.opennms.netmgt.correlation.drools.config.EngineConfiguration;
import org.opennms.netmgt.model.events.EventIpcManager;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class DroolsCorrelationEngineBuilder
extends PropertyEditorRegistrySupport
implements InitializingBean,
ApplicationListener<ApplicationEvent> {
    public static final String PLUGIN_CONFIG_FILE_NAME = "drools-engine.xml";
    private File m_configDirectory;
    private Resource m_configResource;
    private EventIpcManager m_eventIpcManager;
    private CorrelationEngineRegistrar m_correlator;
    private PluginConfiguration[] m_pluginConfigurations;

    public DroolsCorrelationEngineBuilder() {
        this.registerDefaultEditors();
    }

    public void assertSet(Object obj, String name) {
        Assert.state((obj != null ? 1 : 0) != 0, (String)(name + " required for DroolsEngineFactoryBean"));
    }

    public void afterPropertiesSet() throws Exception {
        this.assertSet(this.m_configDirectory, "configurationDirectory");
        this.assertSet(this.m_eventIpcManager, "eventIpcManager");
        this.assertSet(this.m_correlator, "correlator");
        Assert.state((!this.m_configDirectory.exists() || this.m_configDirectory.isDirectory() ? 1 : 0) != 0, (String)(this.m_configDirectory + " must be a directory!"));
        this.readConfiguration();
    }

    private void registerEngines(ApplicationContext appContext) {
        for (PluginConfiguration pluginConfig : this.m_pluginConfigurations) {
            this.m_correlator.addCorrelationEngines(pluginConfig.constructEngines(appContext, this.m_eventIpcManager));
        }
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setConfigurationResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    public void setConfigurationDirectory(File configDirectory) {
        this.m_configDirectory = configDirectory;
    }

    public void setCorrelationEngineRegistrar(CorrelationEngineRegistrar correlator) {
        this.m_correlator = correlator;
    }

    private void readConfiguration() throws Exception {
        for (PluginConfiguration pluginCofig : this.m_pluginConfigurations = this.locatePluginConfigurations()) {
            pluginCofig.readConfig();
        }
    }

    private PluginConfiguration[] locatePluginConfigurations() throws Exception {
        File[] pluginDirs;
        LinkedList<PluginConfiguration> pluginConfigs = new LinkedList<PluginConfiguration>();
        if (this.m_configResource != null && this.m_configResource.isReadable()) {
            LogUtils.infof((Object)((Object)this), (String)"Found Drools Plugin config file %s.", (Object[])new Object[]{this.m_configResource});
            pluginConfigs.add(new PluginConfiguration(this.m_configResource));
        }
        for (File pluginDir : pluginDirs = this.getPluginDirs()) {
            File configFile = new File(pluginDir, PLUGIN_CONFIG_FILE_NAME);
            if (!configFile.exists()) {
                LogUtils.errorf((Object)((Object)this), (String)"Drools Plugin directory %s does not contains a %s config file.  Ignoring plugin.", (Object[])new Object[]{pluginDir, PLUGIN_CONFIG_FILE_NAME});
                continue;
            }
            LogUtils.infof((Object)((Object)this), (String)"Found Drools Plugin directory %s containing a %s config file.", (Object[])new Object[]{pluginDir, PLUGIN_CONFIG_FILE_NAME});
            pluginConfigs.add(new PluginConfiguration((Resource)new FileSystemResource(configFile)));
        }
        return pluginConfigs.toArray(new PluginConfiguration[0]);
    }

    private File[] getPluginDirs() throws Exception {
        LogUtils.debugf((Object)((Object)this), (String)"Checking %s for drools correlation plugins", (Object[])new Object[]{this.m_configDirectory});
        if (!this.m_configDirectory.exists()) {
            LogUtils.debugf((Object)((Object)this), (String)"Plugin configuration directory does not exists.", (Object[])new Object[0]);
            return new File[0];
        }
        File[] pluginDirs = this.m_configDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        LogUtils.debugf((Object)((Object)this), (String)"Found %d drools correlation plugin sub directories", (Object[])new Object[]{pluginDirs.length});
        return pluginDirs;
    }

    public void onApplicationEvent(ApplicationEvent appEvent) {
        ApplicationContext appContext;
        if (appEvent instanceof ContextRefreshedEvent && !((appContext = ((ContextRefreshedEvent)appEvent).getApplicationContext()) instanceof ConfigFileApplicationContext)) {
            this.registerEngines(appContext);
        }
    }

    private static class PluginConfiguration {
        private Resource m_configResource;
        private EngineConfiguration m_configuration;

        public PluginConfiguration(Resource configResource) {
            this.m_configResource = configResource;
        }

        public void readConfig() {
            LogUtils.infof((Object)this, (String)"Parsing drools engine configuration at %s.", (Object[])new Object[]{this.m_configResource});
            this.m_configuration = (EngineConfiguration)JaxbUtils.unmarshal(EngineConfiguration.class, (Resource)this.m_configResource);
        }

        public CorrelationEngine[] constructEngines(ApplicationContext appContext, EventIpcManager eventIpcManager) {
            LogUtils.infof((Object)this, (String)"Creating drools engins for configuration %s.", (Object[])new Object[]{this.m_configResource});
            return this.m_configuration.constructEngines(this.m_configResource, appContext, eventIpcManager);
        }
    }
}

