/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.asn1.crmf;

import java.util.Enumeration;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERBitString;
import org.opennms.shaded.org.bouncycastle.asn1.DERInteger;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERSequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.opennms.shaded.org.bouncycastle.asn1.crmf.OptionalValidity;
import org.opennms.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509Extensions;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509Name;

public class CertTemplate
extends ASN1Encodable {
    private DERInteger version;
    private DERInteger serialNumber;
    private AlgorithmIdentifier signingAlg;
    private X509Name issuer;
    private OptionalValidity validity;
    private X509Name subject;
    private SubjectPublicKeyInfo publicKey;
    private DERBitString issuerUID;
    private DERBitString subjectUID;
    private X509Extensions extensions;

    private CertTemplate(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        block12: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.version = DERInteger.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 1: {
                    this.serialNumber = DERInteger.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 2: {
                    this.signingAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 3: {
                    this.issuer = X509Name.getInstance(aSN1TaggedObject, true);
                    continue block12;
                }
                case 4: {
                    this.validity = OptionalValidity.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, false));
                    continue block12;
                }
                case 5: {
                    this.subject = X509Name.getInstance(aSN1TaggedObject, true);
                    continue block12;
                }
                case 6: {
                    this.publicKey = SubjectPublicKeyInfo.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 7: {
                    this.issuerUID = DERBitString.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 8: {
                    this.subjectUID = DERBitString.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
                case 9: {
                    this.extensions = X509Extensions.getInstance(aSN1TaggedObject, false);
                    continue block12;
                }
            }
            throw new IllegalArgumentException("unknown tag: " + aSN1TaggedObject.getTagNo());
        }
    }

    public static CertTemplate getInstance(Object object) {
        if (object instanceof CertTemplate) {
            return (CertTemplate)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CertTemplate((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.addOptional(aSN1EncodableVector, 0, false, this.version);
        this.addOptional(aSN1EncodableVector, 1, false, this.serialNumber);
        this.addOptional(aSN1EncodableVector, 2, false, this.signingAlg);
        this.addOptional(aSN1EncodableVector, 3, true, this.issuer);
        this.addOptional(aSN1EncodableVector, 4, false, this.validity);
        this.addOptional(aSN1EncodableVector, 5, true, this.subject);
        this.addOptional(aSN1EncodableVector, 6, false, this.publicKey);
        this.addOptional(aSN1EncodableVector, 7, false, this.issuerUID);
        this.addOptional(aSN1EncodableVector, 8, false, this.subjectUID);
        this.addOptional(aSN1EncodableVector, 9, false, this.extensions);
        return new DERSequence(aSN1EncodableVector);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, boolean bl, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(bl, n, aSN1Encodable));
        }
    }
}

