/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeatureFinder;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="feature", name="chooseurl", description="Add a repository url for well known features")
public class ChooseUrlCommand
extends AbstractAction {
    @Argument(index=0, name="", description="", required=true, multiValued=false)
    private String name;
    @Argument(index=1, name="", description="", required=false, multiValued=false)
    private String version;
    private FeatureFinder featureFinder;
    private FeaturesService featuresService;

    public void setFeatureFinder(FeatureFinder featureFinder) {
        this.featureFinder = featureFinder;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected Object doExecute() throws Exception {
        String effectiveVersion = this.version == null ? "LATEST" : this.version;
        URI uri = this.featureFinder.getUriFor(this.name, effectiveVersion);
        if (uri == null) {
            throw new RuntimeException("No feature found for name " + this.name + " and version " + this.version);
        }
        System.out.println("adding feature url " + uri);
        this.featuresService.addRepository(uri);
        return null;
    }
}

