/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;

@Command(scope="jaas", name="manage", description="Manage users and roles of a JAAS Realm")
public class ManageRealmCommand
extends JaasCommandSupport {
    @Option(name="--realm", description="Realm Name", required=false, multiValued=false)
    String realmName;
    @Option(name="--index", description="Realm Index", required=false, multiValued=false)
    int index;
    @Option(name="--module", aliases={}, description="Login Module Class Name", required=false, multiValued=false)
    String moduleName;
    @Option(name="-f", aliases={"--force"}, description="Force the management of this realm, even if another one was under management", required=false, multiValued=false)
    boolean force;

    protected Object doExecute() throws Exception {
        if (this.realmName == null && this.index <= 0) {
            System.err.println("A valid realm or the realm index need to be specified");
            return null;
        }
        JaasRealm oldRealm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry oldEntry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (oldRealm != null && !oldRealm.getName().equals(this.realmName) && !this.force) {
            System.err.println("Another JAAS Realm is being edited. Cancel/update first, or use the --force option.");
        } else if (oldEntry != null && !oldEntry.getLoginModuleName().equals(this.moduleName) && !this.force) {
            System.err.println("Another JAAS Login Module is being edited. Cancel/update first, or use the --force option.");
        } else {
            List<JaasRealm> realms;
            JaasRealm realm = null;
            AppConfigurationEntry entry = null;
            if (this.index > 0) {
                realms = this.getRealms();
                if (realms != null && realms.size() > 0) {
                    int i = 1;
                    block0: for (JaasRealm r : realms) {
                        AppConfigurationEntry[] entries = r.getEntries();
                        if (entries == null) continue;
                        for (int j = 0; j < entries.length; ++j) {
                            if (i == this.index) {
                                realm = r;
                                entry = entries[j];
                                continue block0;
                            }
                            ++i;
                        }
                    }
                }
            } else {
                AppConfigurationEntry[] entries;
                realms = this.getRealms();
                if (realms != null && realms.size() > 0) {
                    for (JaasRealm r : realms) {
                        if (!r.getName().equals(this.realmName)) continue;
                        realm = r;
                        break;
                    }
                }
                if ((entries = realm.getEntries()) != null) {
                    for (AppConfigurationEntry e : entries) {
                        String moduleClass = (String)e.getOptions().get("org.apache.karaf.jaas.module");
                        if (this.moduleName == null) {
                            entry = e;
                        } else {
                            if (!this.moduleName.equals(e.getLoginModuleName()) && !this.moduleName.equals(moduleClass)) continue;
                            entry = e;
                        }
                        break;
                    }
                }
            }
            if (realm == null) {
                System.err.println("JAAS realm has not been found.");
                return null;
            }
            if (entry == null) {
                System.err.println("JAAS module has not been found.");
                return null;
            }
            LinkedList commands = null;
            commands = (LinkedList)this.session.get("JaasCommand.COMMANDS");
            if (commands == null) {
                commands = new LinkedList();
            }
            this.session.put("JaasCommand.REALM", realm);
            this.session.put("JaasCommand.ENTRY", entry);
            this.session.put("JaasCommand.COMMANDS", commands);
        }
        return null;
    }

    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }
}

