/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.service.http.HttpContext;

class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_RANGE = "If-Range";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String KEEP_ALIVE = "Keep-Alive";
    private static final String ETAG = "ETag";
    private final HttpContext m_httpContext;
    private final String m_contextName;
    private final String m_alias;
    private final String m_name;
    private final MimeTypes mimeTypes = new MimeTypes();

    ResourceServlet(HttpContext httpContext, String contextName, String alias, String name) {
        this.m_httpContext = httpContext;
        this.m_contextName = "/" + contextName;
        this.m_alias = alias;
        this.m_name = "/".equals(name) ? "" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mapping;
        Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included != null && included.booleanValue()) {
            String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
            mapping = URIUtil.addPaths((String)servletPath, (String)pathInfo);
        } else {
            included = Boolean.FALSE;
            if (this.m_contextName.equals(this.m_alias)) {
                mapping = !"default".equalsIgnoreCase(this.m_name) ? this.m_name + request.getRequestURI() : request.getRequestURI();
            } else {
                mapping = request.getRequestURI().replaceFirst(this.m_contextName, "/");
                if (!"default".equalsIgnoreCase(this.m_name)) {
                    mapping = mapping.replaceFirst(this.m_alias, this.m_name);
                }
            }
        }
        URL url = this.m_httpContext.getResource(mapping);
        if (url == null) {
            response.sendError(404);
            return;
        }
        Resource resource = ResourceEx.newResource(url, true);
        try {
            ServletOutputStream out;
            long modifiedSince;
            if (!resource.exists()) {
                response.sendError(404);
                return;
            }
            if (resource.isDirectory()) {
                response.sendError(403);
                return;
            }
            String eTag = String.valueOf(resource.lastModified());
            if (request.getHeader(IF_NONE_MATCH) != null && eTag.equals(request.getHeader(IF_NONE_MATCH))) {
                response.setStatus(304);
                return;
            }
            if (request.getHeader(IF_MODIFIED_SINCE) != null) {
                long ifModifiedSince = request.getDateHeader(IF_MODIFIED_SINCE);
                if (resource.lastModified() != -1L && resource.lastModified() / 1000L <= ifModifiedSince / 1000L) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return;
                }
            } else if (request.getHeader(IF_UNMODIFIED_SINCE) != null && (modifiedSince = request.getDateHeader(IF_UNMODIFIED_SINCE)) != -1L && resource.lastModified() / 1000L > modifiedSince / 1000L) {
                response.sendError(412);
                return;
            }
            response.setHeader(ETAG, eTag);
            String mimeType = this.m_httpContext.getMimeType(mapping);
            if (mimeType == null) {
                Buffer mimeTypeBuf = this.mimeTypes.getMimeByExtension(mapping);
                String string = mimeType = mimeTypeBuf != null ? mimeTypeBuf.toString() : null;
            }
            if (mimeType == null) {
                try {
                    mimeType = url.openConnection().getContentType();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            if ((out = response.getOutputStream()) != null) {
                if (out instanceof AbstractHttpConnection.Output) {
                    ((AbstractHttpConnection.Output)out).sendContent((Object)resource.getInputStream());
                } else {
                    resource.writeTo((OutputStream)out, 0L, resource.length());
                }
            }
            response.setStatus(200);
        }
        finally {
            resource.release();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + "context=" + this.m_contextName + ",alias=" + this.m_alias + ",name=" + this.m_name + "}";
    }

    public static abstract class ResourceEx
    extends Resource {
        private static final Method method;

        public static Resource newResource(URL url, boolean useCaches) throws IOException {
            try {
                return (Resource)method.invoke(null, url, useCaches);
            }
            catch (Throwable t) {
                return Resource.newResource((URL)url);
            }
        }

        static {
            Method mth = null;
            try {
                mth = Resource.class.getDeclaredMethod("newResource", URL.class, Boolean.TYPE);
                mth.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            method = mth;
        }
    }
}

