/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.asm.Type;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import org.springframework.cglib.core.ClassGenerator;
import org.springframework.cglib.core.DefaultGeneratorStrategy;
import org.springframework.cglib.core.GeneratorStrategy;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.proxy.NoOp;
import org.springframework.cglib.transform.ClassEmitterTransformer;
import org.springframework.cglib.transform.ClassTransformer;
import org.springframework.cglib.transform.TransformingClassGenerator;
import org.springframework.context.annotation.BeanAnnotationHelper;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyCreator;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.SpringObjenesis;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

class ConfigurationClassEnhancer {
    private static final Callback[] CALLBACKS = new Callback[]{new BeanMethodInterceptor(), new BeanFactoryAwareMethodInterceptor(), NoOp.INSTANCE};
    private static final ConditionalCallbackFilter CALLBACK_FILTER = new ConditionalCallbackFilter(CALLBACKS);
    private static final String BEAN_FACTORY_FIELD = "$$beanFactory";
    private static final Log logger = LogFactory.getLog(ConfigurationClassEnhancer.class);
    private static final SpringObjenesis objenesis = new SpringObjenesis();

    ConfigurationClassEnhancer() {
    }

    public Class<?> enhance(Class<?> configClass, ClassLoader classLoader) {
        if (EnhancedConfiguration.class.isAssignableFrom(configClass)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Ignoring request to enhance %s as it has already been enhanced. This usually indicates that more than one ConfigurationClassPostProcessor has been registered (e.g. via <context:annotation-config>). This is harmless, but you may want check your configuration and remove one CCPP if possible", configClass.getName()));
            }
            return configClass;
        }
        Class<?> enhancedClass = this.createClass(this.newEnhancer(configClass, classLoader));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Successfully enhanced %s; enhanced class name is: %s", configClass.getName(), enhancedClass.getName()));
        }
        return enhancedClass;
    }

    private Enhancer newEnhancer(Class<?> superclass, ClassLoader classLoader) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(superclass);
        enhancer.setInterfaces(new Class[]{EnhancedConfiguration.class});
        enhancer.setUseFactory(false);
        enhancer.setNamingPolicy((NamingPolicy)SpringNamingPolicy.INSTANCE);
        enhancer.setStrategy((GeneratorStrategy)new BeanFactoryAwareGeneratorStrategy(classLoader));
        enhancer.setCallbackFilter((CallbackFilter)CALLBACK_FILTER);
        enhancer.setCallbackTypes((Class[])CALLBACK_FILTER.getCallbackTypes());
        return enhancer;
    }

    private Class<?> createClass(Enhancer enhancer) {
        Class subclass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)subclass, (Callback[])CALLBACKS);
        return subclass;
    }

    private static class BeanMethodInterceptor
    implements MethodInterceptor,
    ConditionalCallback {
        private BeanMethodInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object enhancedConfigInstance, Method beanMethod, Object[] beanMethodArgs, MethodProxy cglibMethodProxy) throws Throwable {
            Object factoryBean;
            String scopedBeanName;
            ConfigurableBeanFactory beanFactory = this.getBeanFactory(enhancedConfigInstance);
            String beanName = BeanAnnotationHelper.determineBeanNameFor(beanMethod);
            Scope scope = (Scope)AnnotationUtils.findAnnotation((Method)beanMethod, Scope.class);
            if (scope != null && scope.proxyMode() != ScopedProxyMode.NO && beanFactory.isCurrentlyInCreation(scopedBeanName = ScopedProxyCreator.getTargetBeanName(beanName))) {
                beanName = scopedBeanName;
            }
            if (this.factoryContainsBean(beanFactory, "&" + beanName) && this.factoryContainsBean(beanFactory, beanName) && !((factoryBean = beanFactory.getBean("&" + beanName)) instanceof ScopedProxyFactoryBean)) {
                return this.enhanceFactoryBean(factoryBean, beanFactory, beanName);
            }
            if (this.isCurrentlyInvokedFactoryMethod(beanMethod)) {
                if (logger.isWarnEnabled() && BeanFactoryPostProcessor.class.isAssignableFrom(beanMethod.getReturnType())) {
                    logger.warn((Object)String.format("@Bean method %s.%s is non-static and returns an object assignable to Spring's BeanFactoryPostProcessor interface. This will result in a failure to process annotations such as @Autowired, @Resource and @PostConstruct within the method's declaring @Configuration class. Add the 'static' modifier to this method to avoid these container lifecycle issues; see @Bean javadoc for complete details.", beanMethod.getDeclaringClass().getSimpleName(), beanMethod.getName()));
                }
                return cglibMethodProxy.invokeSuper(enhancedConfigInstance, beanMethodArgs);
            }
            boolean alreadyInCreation = beanFactory.isCurrentlyInCreation(beanName);
            try {
                Object beanInstance;
                boolean useArgs;
                if (alreadyInCreation) {
                    beanFactory.setCurrentlyInCreation(beanName, false);
                }
                boolean bl = useArgs = !ObjectUtils.isEmpty((Object[])beanMethodArgs);
                if (useArgs && beanFactory.isSingleton(beanName)) {
                    for (Object arg : beanMethodArgs) {
                        if (arg != null) continue;
                        useArgs = false;
                        break;
                    }
                }
                Object object = beanInstance = useArgs ? beanFactory.getBean(beanName, beanMethodArgs) : beanFactory.getBean(beanName);
                if (beanInstance != null && !ClassUtils.isAssignableValue(beanMethod.getReturnType(), (Object)beanInstance)) {
                    String msg = String.format("@Bean method %s.%s called as a bean reference for type [%s] but overridden by non-compatible bean instance of type [%s].", beanMethod.getDeclaringClass().getSimpleName(), beanMethod.getName(), beanMethod.getReturnType().getName(), beanInstance.getClass().getName());
                    try {
                        BeanDefinition beanDefinition = beanFactory.getMergedBeanDefinition(beanName);
                        msg = msg + " Overriding bean of same name declared in: " + beanDefinition.getResourceDescription();
                    }
                    catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                        // empty catch block
                    }
                    throw new IllegalStateException(msg);
                }
                Object object2 = beanInstance;
                return object2;
            }
            finally {
                if (alreadyInCreation) {
                    beanFactory.setCurrentlyInCreation(beanName, true);
                }
            }
        }

        private boolean factoryContainsBean(ConfigurableBeanFactory beanFactory, String beanName) {
            return beanFactory.containsBean(beanName) && !beanFactory.isCurrentlyInCreation(beanName);
        }

        private boolean isCurrentlyInvokedFactoryMethod(Method method) {
            Method currentlyInvoked = SimpleInstantiationStrategy.getCurrentlyInvokedFactoryMethod();
            return currentlyInvoked != null && method.getName().equals(currentlyInvoked.getName()) && Arrays.equals(method.getParameterTypes(), currentlyInvoked.getParameterTypes());
        }

        private Object enhanceFactoryBean(final Object factoryBean, final ConfigurableBeanFactory beanFactory, final String beanName) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(factoryBean.getClass());
            enhancer.setNamingPolicy((NamingPolicy)SpringNamingPolicy.INSTANCE);
            enhancer.setCallbackType(MethodInterceptor.class);
            Class fbClass = enhancer.createClass();
            Object fbProxy = null;
            if (objenesis.isWorthTrying()) {
                try {
                    fbProxy = objenesis.newInstance(fbClass, enhancer.getUseCache());
                }
                catch (ObjenesisException ex) {
                    logger.debug((Object)"Unable to instantiate enhanced FactoryBean using Objenesis, falling back to regular construction", (Throwable)ex);
                }
            }
            if (fbProxy == null) {
                try {
                    fbProxy = fbClass.newInstance();
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Unable to instantiate enhanced FactoryBean using Objenesis, and regular FactoryBean instantiation via default constructor fails as well", ex);
                }
            }
            ((Factory)fbProxy).setCallback(0, (Callback)new MethodInterceptor(){

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    if (method.getName().equals("getObject") && args.length == 0) {
                        return beanFactory.getBean(beanName);
                    }
                    return proxy.invoke(factoryBean, args);
                }
            });
            return fbProxy;
        }

        private ConfigurableBeanFactory getBeanFactory(Object enhancedConfigInstance) {
            Field field = ReflectionUtils.findField(enhancedConfigInstance.getClass(), (String)ConfigurationClassEnhancer.BEAN_FACTORY_FIELD);
            Assert.state((field != null ? 1 : 0) != 0, (String)"Unable to find generated bean factory field");
            Object beanFactory = ReflectionUtils.getField((Field)field, (Object)enhancedConfigInstance);
            Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory has not been injected into @Configuration class");
            Assert.state((boolean)(beanFactory instanceof ConfigurableBeanFactory), (String)"Injected BeanFactory is not a ConfigurableBeanFactory");
            return (ConfigurableBeanFactory)beanFactory;
        }

        @Override
        public boolean isMatch(Method candidateMethod) {
            return BeanAnnotationHelper.isBeanAnnotated(candidateMethod);
        }
    }

    private static class BeanFactoryAwareMethodInterceptor
    implements MethodInterceptor,
    ConditionalCallback {
        private BeanFactoryAwareMethodInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Field field = obj.getClass().getDeclaredField(ConfigurationClassEnhancer.BEAN_FACTORY_FIELD);
            Assert.state((field != null ? 1 : 0) != 0, (String)"Unable to find generated BeanFactory field");
            field.set(obj, args[0]);
            if (BeanFactoryAware.class.isAssignableFrom(obj.getClass().getSuperclass())) {
                return proxy.invokeSuper(obj, args);
            }
            return null;
        }

        @Override
        public boolean isMatch(Method candidateMethod) {
            return candidateMethod.getName().equals("setBeanFactory") && candidateMethod.getParameterTypes().length == 1 && BeanFactory.class == candidateMethod.getParameterTypes()[0] && BeanFactoryAware.class.isAssignableFrom(candidateMethod.getDeclaringClass());
        }
    }

    private static class BeanFactoryAwareGeneratorStrategy
    extends DefaultGeneratorStrategy {
        private final ClassLoader classLoader;

        public BeanFactoryAwareGeneratorStrategy(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        protected ClassGenerator transform(ClassGenerator cg) throws Exception {
            ClassEmitterTransformer transformer = new ClassEmitterTransformer(){

                public void end_class() {
                    this.declare_field(1, ConfigurationClassEnhancer.BEAN_FACTORY_FIELD, Type.getType(BeanFactory.class), null);
                    super.end_class();
                }
            };
            return new TransformingClassGenerator(cg, (ClassTransformer)transformer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] generate(ClassGenerator cg) throws Exception {
            boolean overrideClassLoader;
            ClassLoader threadContextClassLoader;
            if (this.classLoader == null) {
                return super.generate(cg);
            }
            Thread currentThread = Thread.currentThread();
            try {
                threadContextClassLoader = currentThread.getContextClassLoader();
            }
            catch (Throwable ex) {
                return super.generate(cg);
            }
            boolean bl = overrideClassLoader = !this.classLoader.equals(threadContextClassLoader);
            if (overrideClassLoader) {
                currentThread.setContextClassLoader(this.classLoader);
            }
            try {
                byte[] byArray = super.generate(cg);
                return byArray;
            }
            finally {
                if (overrideClassLoader) {
                    currentThread.setContextClassLoader(threadContextClassLoader);
                }
            }
        }
    }

    private static class ConditionalCallbackFilter
    implements CallbackFilter {
        private final Callback[] callbacks;
        private final Class<?>[] callbackTypes;

        public ConditionalCallbackFilter(Callback[] callbacks) {
            this.callbacks = callbacks;
            this.callbackTypes = new Class[callbacks.length];
            for (int i = 0; i < callbacks.length; ++i) {
                this.callbackTypes[i] = callbacks[i].getClass();
            }
        }

        public int accept(Method method) {
            for (int i = 0; i < this.callbacks.length; ++i) {
                if (this.callbacks[i] instanceof ConditionalCallback && !((ConditionalCallback)this.callbacks[i]).isMatch(method)) continue;
                return i;
            }
            throw new IllegalStateException("No callback available for method " + method.getName());
        }

        public Class<?>[] getCallbackTypes() {
            return this.callbackTypes;
        }
    }

    private static interface ConditionalCallback
    extends Callback {
        public boolean isMatch(Method var1);
    }

    public static interface EnhancedConfiguration
    extends BeanFactoryAware {
    }
}

