/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.service.RepositoryPlugin;
import aQute.service.reporter.Reporter;
import java.io.File;

public class DownloadBlocker
implements RepositoryPlugin.DownloadListener {
    private volatile Stage stage = Stage.INIT;
    private String failure;
    private File file;
    private final Reporter reporter;

    public DownloadBlocker(Reporter reporter) {
        this.reporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void success(File file) throws Exception {
        DownloadBlocker downloadBlocker = this;
        synchronized (downloadBlocker) {
            assert (this.stage == Stage.INIT);
            this.stage = Stage.SUCCESS;
            this.file = file;
            this.notifyAll();
        }
        if (this.reporter != null) {
            this.reporter.trace("successfully downloaded %s", file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(File file, String reason) throws Exception {
        DownloadBlocker downloadBlocker = this;
        synchronized (downloadBlocker) {
            assert (this.stage == Stage.INIT);
            this.stage = Stage.FAILURE;
            this.failure = reason;
            this.file = file;
            this.notifyAll();
        }
        if (this.reporter != null) {
            this.reporter.error("Download %s %s", reason, file);
        }
    }

    public boolean progress(File file, int percentage) throws Exception {
        assert (this.stage == Stage.INIT);
        return true;
    }

    public synchronized String getReason() {
        try {
            while (this.stage == Stage.INIT) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            return "Interrupted";
        }
        return this.failure;
    }

    public Stage getStage() {
        return this.stage;
    }

    public File getFile() {
        if (this.getReason() == null) {
            return this.file;
        }
        return null;
    }

    public String toString() {
        return "DownloadBlocker [stage=" + (Object)((Object)this.stage) + ", failure=" + this.failure + ", file=" + this.file + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stage {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

