/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ops4j.pax.web.extender.war.internal.DefaultWebAppDependencyHolder;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.tracker.ReplaceableService;
import org.ops4j.pax.web.extender.war.internal.tracker.ReplaceableServiceListener;
import org.ops4j.pax.web.service.WebAppDependencyHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebAppDependencyManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWebAppDependencyHolder.class);
    private ConcurrentMap<WebApp, ReplaceableService<HttpService>> trackers = new ConcurrentHashMap<WebApp, ReplaceableService<HttpService>>();
    private ConcurrentHashMap<WebApp, ServiceRegistration<WebAppDependencyHolder>> services = new ConcurrentHashMap();

    public void addWebApp(final WebApp webApp) {
        final BundleContext webAppContext = webApp.getBundle().getBundleContext();
        ReplaceableService<HttpService> tracker = new ReplaceableService<HttpService>(webAppContext, HttpService.class, new ReplaceableServiceListener<HttpService>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serviceChanged(HttpService oldService, HttpService newService) {
                ServiceRegistration oldReg;
                ServiceRegistration newReg;
                Object holder;
                if (newService != null) {
                    holder = new DefaultWebAppDependencyHolder(newService);
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("bundle.id", Long.toString(webApp.getBundle().getBundleId()));
                    newReg = webAppContext.registerService(WebAppDependencyHolder.class, holder, props);
                } else {
                    newReg = null;
                }
                holder = this;
                synchronized (holder) {
                    ServiceRegistration serviceRegistration = oldReg = DefaultWebAppDependencyManager.this.services.containsKey(webApp) ? (ServiceRegistration)DefaultWebAppDependencyManager.this.services.get(webApp) : null;
                    if (newReg != null) {
                        DefaultWebAppDependencyManager.this.services.put(webApp, newReg);
                    } else {
                        DefaultWebAppDependencyManager.this.services.remove(webApp);
                    }
                }
                if (oldReg != null) {
                    try {
                        oldReg.unregister();
                    }
                    catch (IllegalStateException e) {
                        LOG.info("Unregistering an alredy unregistered Service: {} ", oldReg.getClass());
                    }
                }
            }
        });
        if (this.trackers.putIfAbsent(webApp, tracker) == null) {
            tracker.start();
        }
    }

    public void removeWebApp(WebApp webApp) {
        ReplaceableService tracker;
        ServiceRegistration<WebAppDependencyHolder> serviceRegistration = this.services.get(webApp);
        if (serviceRegistration != null) {
            try {
                serviceRegistration.unregister();
            }
            catch (IllegalStateException e) {
                LOG.info("Unregistering an alredy unregistered Service: {} ", serviceRegistration.getClass());
            }
        }
        if ((tracker = (ReplaceableService)this.trackers.remove(webApp)) != null) {
            tracker.stop();
        }
    }
}

