/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.OrderComparator;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractApplicationEventMulticaster
implements ApplicationEventMulticaster,
BeanClassLoaderAware,
BeanFactoryAware {
    private final ListenerRetriever defaultRetriever = new ListenerRetriever(false);
    private final Map<ListenerCacheKey, ListenerRetriever> retrieverCache = new ConcurrentHashMap<ListenerCacheKey, ListenerRetriever>(64);
    private ClassLoader beanClassLoader;
    private BeanFactory beanFactory;
    private Object retrievalMutex = this.defaultRetriever;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (this.beanClassLoader == null && beanFactory instanceof ConfigurableBeanFactory) {
            this.beanClassLoader = ((ConfigurableBeanFactory)beanFactory).getBeanClassLoader();
        }
        if (beanFactory instanceof AbstractBeanFactory) {
            this.retrievalMutex = ((AbstractBeanFactory)beanFactory).getSingletonMutex();
        }
    }

    private BeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("ApplicationEventMulticaster cannot retrieve listener beans because it is not associated with a BeanFactory");
        }
        return this.beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationListener(ApplicationListener<?> listener) {
        Object object = this.retrievalMutex;
        synchronized (object) {
            this.defaultRetriever.applicationListeners.add(listener);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationListenerBean(String listenerBeanName) {
        Object object = this.retrievalMutex;
        synchronized (object) {
            this.defaultRetriever.applicationListenerBeans.add(listenerBeanName);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListener(ApplicationListener<?> listener) {
        Object object = this.retrievalMutex;
        synchronized (object) {
            this.defaultRetriever.applicationListeners.remove(listener);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListenerBean(String listenerBeanName) {
        Object object = this.retrievalMutex;
        synchronized (object) {
            this.defaultRetriever.applicationListenerBeans.remove(listenerBeanName);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListeners() {
        Object object = this.retrievalMutex;
        synchronized (object) {
            this.defaultRetriever.applicationListeners.clear();
            this.defaultRetriever.applicationListenerBeans.clear();
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ApplicationListener<?>> getApplicationListeners() {
        Object object = this.retrievalMutex;
        synchronized (object) {
            return this.defaultRetriever.getApplicationListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ApplicationListener<?>> getApplicationListeners(ApplicationEvent event) {
        Object source = event.getSource();
        Class<?> sourceType = source != null ? source.getClass() : null;
        ListenerCacheKey cacheKey = new ListenerCacheKey(event.getClass(), sourceType);
        ListenerRetriever retriever = this.retrieverCache.get(cacheKey);
        if (retriever != null) {
            return retriever.getApplicationListeners();
        }
        if (this.beanClassLoader == null || ClassUtils.isCacheSafe(event.getClass(), (ClassLoader)this.beanClassLoader) && (sourceType == null || ClassUtils.isCacheSafe(sourceType, (ClassLoader)this.beanClassLoader))) {
            Object object = this.retrievalMutex;
            synchronized (object) {
                retriever = this.retrieverCache.get(cacheKey);
                if (retriever != null) {
                    return retriever.getApplicationListeners();
                }
                retriever = new ListenerRetriever(true);
                Collection<ApplicationListener<?>> listeners = this.retrieveApplicationListeners(event, sourceType, retriever);
                this.retrieverCache.put(cacheKey, retriever);
                return listeners;
            }
        }
        return this.retrieveApplicationListeners(event, sourceType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ApplicationListener<?>> retrieveApplicationListeners(ApplicationEvent event, Class<?> sourceType, ListenerRetriever retriever) {
        LinkedHashSet<String> listenerBeans;
        LinkedHashSet listeners;
        LinkedList allListeners = new LinkedList();
        Iterator iterator = this.retrievalMutex;
        synchronized (iterator) {
            listeners = new LinkedHashSet(this.defaultRetriever.applicationListeners);
            listenerBeans = new LinkedHashSet<String>(this.defaultRetriever.applicationListenerBeans);
        }
        for (ApplicationListener applicationListener : listeners) {
            if (!this.supportsEvent(applicationListener, event.getClass(), sourceType)) continue;
            if (retriever != null) {
                retriever.applicationListeners.add(applicationListener);
            }
            allListeners.add(applicationListener);
        }
        if (!listenerBeans.isEmpty()) {
            BeanFactory beanFactory = this.getBeanFactory();
            for (String listenerBeanName : listenerBeans) {
                try {
                    ApplicationListener listener;
                    Class listenerType = beanFactory.getType(listenerBeanName);
                    if (listenerType != null && !this.supportsEvent(listenerType, event) || allListeners.contains(listener = (ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class)) || !this.supportsEvent(listener, event.getClass(), sourceType)) continue;
                    if (retriever != null) {
                        retriever.applicationListenerBeans.add(listenerBeanName);
                    }
                    allListeners.add(listener);
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
            }
        }
        OrderComparator.sort(allListeners);
        return allListeners;
    }

    protected boolean supportsEvent(Class<?> listenerType, ApplicationEvent event) {
        if (SmartApplicationListener.class.isAssignableFrom(listenerType)) {
            return true;
        }
        Class<?> declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(listenerType);
        return declaredEventType == null || declaredEventType.isInstance(event);
    }

    protected boolean supportsEvent(ApplicationListener<?> listener, Class<? extends ApplicationEvent> eventType, Class<?> sourceType) {
        SmartApplicationListener smartListener = listener instanceof SmartApplicationListener ? (SmartApplicationListener)listener : new GenericApplicationListenerAdapter(listener);
        return smartListener.supportsEventType(eventType) && smartListener.supportsSourceType(sourceType);
    }

    private class ListenerRetriever {
        public final Set<ApplicationListener<?>> applicationListeners = new LinkedHashSet();
        public final Set<String> applicationListenerBeans = new LinkedHashSet<String>();
        private final boolean preFiltered;

        public ListenerRetriever(boolean preFiltered) {
            this.preFiltered = preFiltered;
        }

        public Collection<ApplicationListener<?>> getApplicationListeners() {
            LinkedList allListeners = new LinkedList();
            for (ApplicationListener<?> listener : this.applicationListeners) {
                allListeners.add(listener);
            }
            if (!this.applicationListenerBeans.isEmpty()) {
                BeanFactory beanFactory = AbstractApplicationEventMulticaster.this.getBeanFactory();
                for (String listenerBeanName : this.applicationListenerBeans) {
                    try {
                        ApplicationListener listener = (ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class);
                        if (!this.preFiltered && allListeners.contains(listener)) continue;
                        allListeners.add(listener);
                    }
                    catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
                }
            }
            OrderComparator.sort(allListeners);
            return allListeners;
        }
    }

    private static class ListenerCacheKey {
        private final Class<?> eventType;
        private final Class<?> sourceType;

        public ListenerCacheKey(Class<?> eventType, Class<?> sourceType) {
            this.eventType = eventType;
            this.sourceType = sourceType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            ListenerCacheKey otherKey = (ListenerCacheKey)other;
            return ObjectUtils.nullSafeEquals(this.eventType, otherKey.eventType) && ObjectUtils.nullSafeEquals(this.sourceType, otherKey.sourceType);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.eventType) * 29 + ObjectUtils.nullSafeHashCode(this.sourceType);
        }
    }
}

