/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public abstract class AbstractCacheManager
implements CacheManager,
InitializingBean {
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>(16);
    private final Set<String> cacheNames = new LinkedHashSet<String>(16);

    public void afterPropertiesSet() {
        Collection<? extends Cache> caches = this.loadCaches();
        this.cacheMap.clear();
        this.cacheNames.clear();
        for (Cache cache : caches) {
            this.addCache(cache);
        }
    }

    protected abstract Collection<? extends Cache> loadCaches();

    @Override
    public Cache getCache(String name) {
        Cache cache = this.lookupCache(name);
        if (cache != null) {
            return cache;
        }
        Cache missingCache = this.getMissingCache(name);
        if (missingCache != null) {
            this.addCache(missingCache);
            return this.lookupCache(name);
        }
        return null;
    }

    @Override
    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheNames);
    }

    protected final void addCache(Cache cache) {
        this.cacheMap.put(cache.getName(), this.decorateCache(cache));
        this.cacheNames.add(cache.getName());
    }

    protected final Cache lookupCache(String name) {
        return (Cache)this.cacheMap.get(name);
    }

    protected Cache decorateCache(Cache cache) {
        return cache;
    }

    protected Cache getMissingCache(String name) {
        return null;
    }
}

