/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.channels.FileLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.main.ConfigProperties;
import org.apache.karaf.main.ShutdownSocketThread;
import org.apache.karaf.util.locks.FileLockUtils;
import org.osgi.framework.launch.Framework;

public class InstanceHelper {
    static void updateInstancePid(File karafHome, File karafBase, boolean isStartingInstance) {
        block23: {
            try {
                String pid;
                String instanceName = System.getProperty("karaf.name");
                String string = pid = isStartingInstance ? InstanceHelper.getPid() : "0";
                if (instanceName == null) break block23;
                String storage = System.getProperty("karaf.instances");
                if (storage == null) {
                    throw new Exception("System property 'karaf.instances' is not set. \nThis property needs to be set to the full path of the instance.properties file.");
                }
                File storageFile = new File(storage);
                File propertiesFile = new File(storageFile, "instance.properties");
                if (!propertiesFile.getParentFile().exists()) {
                    try {
                        if (!propertiesFile.getParentFile().mkdirs()) {
                            throw new Exception("Unable to create directory " + propertiesFile.getParentFile());
                        }
                    }
                    catch (SecurityException se) {
                        throw new Exception(se.getMessage());
                    }
                }
                if (!isStartingInstance) {
                    boolean proceed = true;
                    try (RandomAccessFile raf = new RandomAccessFile(propertiesFile, "rw");){
                        FileLock lock = raf.getChannel().tryLock();
                        if (lock == null) {
                            proceed = false;
                        } else {
                            lock.release();
                        }
                    }
                    if (!proceed) {
                        return;
                    }
                }
                FileLockUtils.execute(propertiesFile, props -> {
                    if (props.isEmpty()) {
                        props.put("count", (Object)"1");
                        props.put("item.0.name", (Object)instanceName);
                        props.put("item.0.loc", (Object)karafBase.getAbsolutePath());
                        props.put("item.0.pid", (Object)pid);
                        props.put("item.0.root", (Object)"true");
                    } else {
                        int count = Integer.parseInt(props.get("count").toString());
                        for (int i = 0; i < count; ++i) {
                            String name = props.get("item." + i + ".name").toString();
                            if (!name.equals(instanceName)) continue;
                            props.put("item." + i + ".pid", (Object)pid);
                            return;
                        }
                        props.put("item.0.name", (Object)instanceName);
                        props.put("item.0.pid", (Object)pid);
                    }
                }, true);
            }
            catch (Exception e) {
                System.err.println("Unable to update instance pid: " + e.getMessage());
            }
        }
    }

    private static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        Pattern pattern = Pattern.compile("^([0-9]+)@.+$");
        Matcher matcher = pattern.matcher(name);
        return matcher.matches() ? matcher.group(1) : name;
    }

    static void writePid(String pidFile) {
        try {
            if (pidFile != null) {
                int pid = Integer.parseInt(InstanceHelper.getPid());
                OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(pidFile));
                w.write(Integer.toString(pid));
                ((Writer)w).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static AutoCloseable setupShutdown(ConfigProperties config, Framework framework) {
        try {
            int port = config.shutdownPort;
            String host = config.shutdownHost;
            String portFile = config.portFile;
            String shutdown = config.shutdownCommand;
            if (port >= 0) {
                ServerSocket shutdownSocket = new ServerSocket(port, 1, InetAddress.getByName(host));
                if (port == 0) {
                    port = shutdownSocket.getLocalPort();
                }
                if (portFile != null) {
                    File portF = new File(portFile);
                    portF.getParentFile().mkdirs();
                    OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(portF));
                    w.write(Integer.toString(port));
                    ((Writer)w).close();
                }
                ShutdownSocketThread thread = new ShutdownSocketThread(shutdown, shutdownSocket, framework);
                thread.start();
                return thread;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

