/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.apache.xbean.propertyeditor.ArrayConverter;
import org.apache.xbean.propertyeditor.ArrayListEditor;
import org.apache.xbean.propertyeditor.BigDecimalEditor;
import org.apache.xbean.propertyeditor.BigIntegerEditor;
import org.apache.xbean.propertyeditor.BooleanEditor;
import org.apache.xbean.propertyeditor.ByteEditor;
import org.apache.xbean.propertyeditor.CharacterEditor;
import org.apache.xbean.propertyeditor.ClassEditor;
import org.apache.xbean.propertyeditor.CommonsLoggingConverter;
import org.apache.xbean.propertyeditor.ConstructorConverter;
import org.apache.xbean.propertyeditor.Converter;
import org.apache.xbean.propertyeditor.DateEditor;
import org.apache.xbean.propertyeditor.DoubleEditor;
import org.apache.xbean.propertyeditor.EnumConverter;
import org.apache.xbean.propertyeditor.FileEditor;
import org.apache.xbean.propertyeditor.FloatEditor;
import org.apache.xbean.propertyeditor.GenericCollectionConverter;
import org.apache.xbean.propertyeditor.GenericMapConverter;
import org.apache.xbean.propertyeditor.HashMapEditor;
import org.apache.xbean.propertyeditor.HashtableEditor;
import org.apache.xbean.propertyeditor.IdentityHashMapEditor;
import org.apache.xbean.propertyeditor.Inet4AddressEditor;
import org.apache.xbean.propertyeditor.Inet6AddressEditor;
import org.apache.xbean.propertyeditor.InetAddressEditor;
import org.apache.xbean.propertyeditor.IntegerEditor;
import org.apache.xbean.propertyeditor.JndiConverter;
import org.apache.xbean.propertyeditor.LinkedHashMapEditor;
import org.apache.xbean.propertyeditor.LinkedHashSetEditor;
import org.apache.xbean.propertyeditor.LinkedListEditor;
import org.apache.xbean.propertyeditor.ListEditor;
import org.apache.xbean.propertyeditor.Log4jConverter;
import org.apache.xbean.propertyeditor.LoggerConverter;
import org.apache.xbean.propertyeditor.LongEditor;
import org.apache.xbean.propertyeditor.MapEditor;
import org.apache.xbean.propertyeditor.ObjectNameEditor;
import org.apache.xbean.propertyeditor.PatternConverter;
import org.apache.xbean.propertyeditor.Primitives;
import org.apache.xbean.propertyeditor.PropertiesEditor;
import org.apache.xbean.propertyeditor.PropertyEditorConverter;
import org.apache.xbean.propertyeditor.PropertyEditorException;
import org.apache.xbean.propertyeditor.SetEditor;
import org.apache.xbean.propertyeditor.ShortEditor;
import org.apache.xbean.propertyeditor.SortedMapEditor;
import org.apache.xbean.propertyeditor.SortedSetEditor;
import org.apache.xbean.propertyeditor.StaticFactoryConverter;
import org.apache.xbean.propertyeditor.StringEditor;
import org.apache.xbean.propertyeditor.TreeMapEditor;
import org.apache.xbean.propertyeditor.TreeSetEditor;
import org.apache.xbean.propertyeditor.URIEditor;
import org.apache.xbean.propertyeditor.URLEditor;
import org.apache.xbean.propertyeditor.VectorEditor;
import org.apache.xbean.propertyeditor.WeakHashMapEditor;
import org.apache.xbean.recipe.RecipeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEditorRegistry
implements Closeable {
    private final ConcurrentMap<Type, Converter> registry = new ConcurrentHashMap<Type, Converter>();

    public PropertyEditorRegistry registerDefaults() {
        this.register(new ArrayListEditor());
        this.register(new BigDecimalEditor());
        this.register(new BigIntegerEditor());
        this.register(new BooleanEditor());
        this.register(new ByteEditor());
        this.register(new CharacterEditor());
        this.register(new ClassEditor());
        this.register(new DateEditor());
        this.register(new DoubleEditor());
        this.register(new FileEditor());
        this.register(new FloatEditor());
        this.register(new HashMapEditor());
        this.register(new HashtableEditor());
        this.register(new IdentityHashMapEditor());
        this.register(new Inet4AddressEditor());
        this.register(new Inet6AddressEditor());
        this.register(new InetAddressEditor());
        this.register(new IntegerEditor());
        this.register(new LinkedHashMapEditor());
        this.register(new LinkedHashSetEditor());
        this.register(new LinkedListEditor());
        this.register(new ListEditor());
        this.register(new LongEditor());
        this.register(new MapEditor());
        this.register(new ObjectNameEditor());
        this.register(new PropertiesEditor());
        this.register(new SetEditor());
        this.register(new ShortEditor());
        this.register(new SortedMapEditor());
        this.register(new SortedSetEditor());
        this.register(new StringEditor());
        this.register(new TreeMapEditor());
        this.register(new TreeSetEditor());
        this.register(new URIEditor());
        this.register(new URLEditor());
        this.register(new LoggerConverter());
        this.register(new PatternConverter());
        this.register(new JndiConverter());
        this.register(new VectorEditor());
        this.register(new WeakHashMapEditor());
        try {
            this.register(new Log4jConverter());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.register(new CommonsLoggingConverter());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public Map<Type, Converter> getRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }

    public Converter register(Converter converter) {
        if (converter == null) {
            throw new NullPointerException("converter is null");
        }
        Class type = converter.getType();
        Converter existing = this.registry.put(type, converter);
        Class<?> sibling = Primitives.findSibling(type);
        if (sibling != null) {
            this.registry.put(sibling, converter);
        }
        return existing;
    }

    public Converter unregister(Converter converter) {
        if (converter == null) {
            throw new NullPointerException("converter is null");
        }
        return (Converter)this.registry.remove(converter.getType());
    }

    public Converter findConverter(Type type) {
        Converter converter = this.findInternalConverter(type);
        if (converter != null) {
            if (!this.registry.containsKey(converter.getType())) {
                this.register(converter);
            }
            return converter;
        }
        converter = this.createConverterFromEditor(type);
        if (converter != null) {
            this.register(converter);
            return converter;
        }
        converter = this.findStructuralConverter(type);
        if (converter != null) {
            this.register(converter);
            return converter;
        }
        return null;
    }

    public String toString(Object value) throws PropertyEditorException {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Class<?> type = this.unwrapClass(value);
        Converter converter = this.findConverter(type);
        if (converter == null) {
            throw new PropertyEditorException("Unable to find PropertyEditor for " + type.getSimpleName());
        }
        return converter.toString(value);
    }

    public Object getValue(String type, String value, ClassLoader classLoader) throws PropertyEditorException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        try {
            return this.getValue(Class.forName(type, true, classLoader), value);
        }
        catch (ClassNotFoundException e) {
            throw new PropertyEditorException("Type class could not be found: " + type);
        }
    }

    public Object getValue(Type type, String value) throws PropertyEditorException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Converter converter = this.findConverter(type);
        if (converter != null) {
            return converter.toObject(value);
        }
        Class clazz = RecipeHelper.toClass(type);
        Converter structuralConverter = this.findStructuralConverter(clazz);
        if (structuralConverter != null) {
            this.register(structuralConverter);
            return structuralConverter.toObject(value);
        }
        throw new PropertyEditorException("Unable to find PropertyEditor for " + clazz.getSimpleName());
    }

    protected Class<?> unwrapClass(Object value) {
        Class<?> aClass = value.getClass();
        while (aClass.getName().contains("$$")) {
            if ((aClass = aClass.getSuperclass()) != null && aClass != Object.class) continue;
            return value.getClass();
        }
        return aClass;
    }

    protected Converter findStructuralConverter(Type type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class clazz = RecipeHelper.toClass(type);
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumConverter(clazz);
        }
        AbstractConverter editor = ConstructorConverter.editor(clazz);
        if (editor != null) {
            return editor;
        }
        editor = StaticFactoryConverter.editor(clazz);
        if (editor != null) {
            return editor;
        }
        return null;
    }

    protected Converter createConverterFromEditor(Type type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class clazz = RecipeHelper.toClass(type);
        PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
        if (editor != null) {
            return new PropertyEditorConverter(clazz);
        }
        if (clazz.isArray() && !clazz.getComponentType().isArray()) {
            PropertyEditor arrayEditor = this.findEditor(clazz.getComponentType());
            if (this.findEditor(clazz.getComponentType()) != null) {
                return new ArrayConverter(clazz, arrayEditor);
            }
        }
        return null;
    }

    protected Converter findInternalConverter(Type type) {
        Class<?>[] declaredClasses;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class clazz = RecipeHelper.toClass(type);
        if (clazz.isArray() && !clazz.getComponentType().isArray()) {
            Converter editor = this.findConverter(clazz.getComponentType());
            if (editor != null) {
                return new ArrayConverter(clazz, editor);
            }
            return null;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Converter editor;
            Type[] types = RecipeHelper.getTypeParameters(Collection.class, type);
            Object componentType = String.class;
            if (types != null && types.length == 1 && types[0] instanceof Class) {
                componentType = types[0];
            }
            if ((editor = this.findConverter((Type)componentType)) != null) {
                if (RecipeHelper.hasDefaultConstructor(clazz)) {
                    return new GenericCollectionConverter(clazz, editor);
                }
                if (SortedSet.class.isAssignableFrom(clazz)) {
                    return new GenericCollectionConverter(TreeSet.class, editor);
                }
                if (Set.class.isAssignableFrom(clazz)) {
                    return new GenericCollectionConverter(LinkedHashSet.class, editor);
                }
                return new GenericCollectionConverter(ArrayList.class, editor);
            }
            return null;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Type[] types = RecipeHelper.getTypeParameters(Map.class, type);
            Object keyType = String.class;
            Object valueType = String.class;
            if (types != null && types.length == 2 && types[0] instanceof Class && types[1] instanceof Class) {
                keyType = types[0];
                valueType = types[1];
            }
            Converter keyConverter = this.findConverter((Type)keyType);
            Converter valueConverter = this.findConverter((Type)valueType);
            if (keyConverter != null && valueConverter != null) {
                if (RecipeHelper.hasDefaultConstructor(clazz)) {
                    return new GenericMapConverter(clazz, keyConverter, valueConverter);
                }
                if (SortedMap.class.isAssignableFrom(clazz)) {
                    return new GenericMapConverter(TreeMap.class, keyConverter, valueConverter);
                }
                if (ConcurrentMap.class.isAssignableFrom(clazz)) {
                    return new GenericMapConverter(ConcurrentHashMap.class, keyConverter, valueConverter);
                }
                return new GenericMapConverter(LinkedHashMap.class, keyConverter, valueConverter);
            }
            return null;
        }
        Converter converter = (Converter)this.registry.get(clazz);
        if (converter != null) {
            return converter;
        }
        for (Class<?> declaredClass : declaredClasses = clazz.getDeclaredClasses()) {
            if (!Converter.class.isAssignableFrom(declaredClass)) continue;
            try {
                converter = (Converter)declaredClass.newInstance();
                this.register(converter);
                converter = (Converter)this.registry.get(clazz);
                if (converter == null) continue;
                return converter;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected PropertyEditor findEditor(Type type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        Class clazz = RecipeHelper.toClass(type);
        PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
        if (editor != null) {
            return editor;
        }
        if (clazz.isArray() && !clazz.getComponentType().isArray() && (editor = this.findEditor(clazz.getComponentType())) != null) {
            return new ArrayConverter(clazz, editor);
        }
        return null;
    }

    @Override
    public void close() {
        for (Converter converter : this.registry.values()) {
            if (!Closeable.class.isInstance(converter)) continue;
            Closeable.class.cast(converter);
        }
        this.registry.clear();
    }
}

