/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPMapEntry;
import org.apache.aries.jmx.blueprint.codec.BPNonNullMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;

public class BPMapMetadata
implements BPNonNullMetadata {
    private String keyType;
    private String valueType;
    private BPMapEntry[] entries;

    public BPMapMetadata(CompositeData map) {
        this.keyType = (String)map.get("KeyType");
        this.valueType = (String)map.get("ValueType");
        CompositeData[] cd_entries = (CompositeData[])map.get("Entries");
        this.entries = new BPMapEntry[cd_entries.length];
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new BPMapEntry(cd_entries[i]);
        }
    }

    public BPMapMetadata(MapMetadata map) {
        this.keyType = map.getKeyType();
        this.valueType = map.getValueType();
        this.entries = new BPMapEntry[map.getEntries().size()];
        int i = 0;
        for (Object arg : map.getEntries()) {
            this.entries[i++] = new BPMapEntry((MapEntry)arg);
        }
    }

    @Override
    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("KeyType", this.keyType);
        items.put("ValueType", this.valueType);
        CompositeData[] cd_entries = new CompositeData[this.entries.length];
        for (int i = 0; i < this.entries.length; ++i) {
            cd_entries[i] = this.entries[i].asCompositeData();
        }
        items.put("Entries", cd_entries);
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.MAP_METADATA_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public BPMapEntry[] getEntries() {
        return this.entries;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getValueType() {
        return this.valueType;
    }
}

