/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.RandomAccess;

public class ImmutableList<E>
extends AbstractList<E>
implements RandomAccess {
    private static final ImmutableList EMPTY_LIST = new ImmutableList();
    final Object[] elements;

    public static <E> ImmutableList<E> newInstance(E ... elements) {
        return elements.length == 0 ? EMPTY_LIST : new ImmutableList<E>(elements);
    }

    public static <E> ImmutableList<E> newInstance(Collection<? extends E> elements) {
        if (elements instanceof ImmutableList) {
            return (ImmutableList)elements;
        }
        return elements.isEmpty() ? EMPTY_LIST : new ImmutableList<E>(elements);
    }

    private ImmutableList() {
        this.elements = new Object[0];
    }

    protected ImmutableList(E ... elements) {
        this.elements = (Object[])elements.clone();
    }

    protected ImmutableList(Collection<? extends E> elements) {
        this.elements = elements.toArray();
    }

    @Override
    public E get(int index) {
        return (E)this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(index);
    }

    private class ListItr
    implements ListIterator<E> {
        int cursor;

        private ListItr(int cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImmutableList.this.size();
        }

        @Override
        public E next() {
            return ImmutableList.this.elements[this.cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            return ImmutableList.this.elements[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

