/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.felix.cm.impl.ConfigurationAdminImpl;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.osgi.service.cm.Configuration;

public class ConfigurationAdapter
implements Configuration {
    private final ConfigurationAdminImpl configurationAdmin;
    private final ConfigurationImpl delegatee;

    ConfigurationAdapter(ConfigurationAdminImpl configurationAdmin, ConfigurationImpl delegatee) {
        this.configurationAdmin = configurationAdmin;
        this.delegatee = delegatee;
    }

    @Override
    public String getPid() {
        this.checkDeleted();
        return this.delegatee.getPidString();
    }

    @Override
    public String getFactoryPid() {
        this.checkDeleted();
        return this.delegatee.getFactoryPidString();
    }

    @Override
    public String getBundleLocation() {
        String bundleLocation = this.delegatee.getBundleLocation();
        this.checkActive();
        this.configurationAdmin.checkPermission(this.delegatee.getConfigurationManager(), bundleLocation == null ? "*" : bundleLocation, true);
        this.checkDeleted();
        return bundleLocation;
    }

    @Override
    public void setBundleLocation(String bundleLocation) {
        this.delegatee.getConfigurationManager().log(4, "setBundleLocation(bundleLocation={0})", new Object[]{bundleLocation});
        this.checkActive();
        String configLocation = this.delegatee.getBundleLocation();
        this.configurationAdmin.checkPermission(this.delegatee.getConfigurationManager(), configLocation == null ? "*" : configLocation, true);
        this.configurationAdmin.checkPermission(this.delegatee.getConfigurationManager(), bundleLocation == null ? "*" : bundleLocation, true);
        this.checkDeleted();
        this.delegatee.setStaticBundleLocation(bundleLocation);
    }

    @Override
    public void update() throws IOException {
        this.delegatee.getConfigurationManager().log(4, "update()", (Throwable)null);
        this.checkActive();
        this.checkDeleted();
        this.delegatee.update();
    }

    @Override
    public void update(Dictionary<String, ?> properties) throws IOException {
        this.delegatee.getConfigurationManager().log(4, "update(properties={0})", new Object[]{properties});
        this.checkActive();
        this.checkDeleted();
        this.delegatee.update(properties);
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        this.checkDeleted();
        return this.delegatee.getProperties(true);
    }

    @Override
    public long getChangeCount() {
        this.checkDeleted();
        return this.delegatee.getRevision();
    }

    @Override
    public void delete() throws IOException {
        this.delegatee.getConfigurationManager().log(4, "delete()", (Throwable)null);
        this.checkActive();
        this.checkDeleted();
        this.delegatee.delete();
    }

    @Override
    public int hashCode() {
        return this.delegatee.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegatee.equals(obj);
    }

    public String toString() {
        return this.delegatee.toString();
    }

    private void checkActive() {
        if (!this.delegatee.isActive()) {
            throw new IllegalStateException("Configuration " + this.delegatee.getPid() + " not backed by an active Configuration Admin Service");
        }
    }

    private void checkDeleted() {
        if (this.delegatee.isDeleted()) {
            throw new IllegalStateException("Configuration " + this.delegatee.getPid() + " deleted");
        }
    }
}

