/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.ops4j.pax.web.descriptor.gen.AuthConstraintType;
import org.ops4j.pax.web.descriptor.gen.CookieConfigType;
import org.ops4j.pax.web.descriptor.gen.DescriptionType;
import org.ops4j.pax.web.descriptor.gen.DispatcherType;
import org.ops4j.pax.web.descriptor.gen.DisplayNameType;
import org.ops4j.pax.web.descriptor.gen.EmptyType;
import org.ops4j.pax.web.descriptor.gen.ErrorPageType;
import org.ops4j.pax.web.descriptor.gen.FilterMappingType;
import org.ops4j.pax.web.descriptor.gen.FilterType;
import org.ops4j.pax.web.descriptor.gen.FormLoginConfigType;
import org.ops4j.pax.web.descriptor.gen.JspConfigType;
import org.ops4j.pax.web.descriptor.gen.JspPropertyGroupType;
import org.ops4j.pax.web.descriptor.gen.ListenerType;
import org.ops4j.pax.web.descriptor.gen.LoginConfigType;
import org.ops4j.pax.web.descriptor.gen.MimeMappingType;
import org.ops4j.pax.web.descriptor.gen.MultipartConfigType;
import org.ops4j.pax.web.descriptor.gen.ParamValueType;
import org.ops4j.pax.web.descriptor.gen.PathType;
import org.ops4j.pax.web.descriptor.gen.RoleNameType;
import org.ops4j.pax.web.descriptor.gen.SecurityConstraintType;
import org.ops4j.pax.web.descriptor.gen.SecurityRoleType;
import org.ops4j.pax.web.descriptor.gen.ServletMappingType;
import org.ops4j.pax.web.descriptor.gen.ServletNameType;
import org.ops4j.pax.web.descriptor.gen.ServletType;
import org.ops4j.pax.web.descriptor.gen.SessionConfigType;
import org.ops4j.pax.web.descriptor.gen.TaglibType;
import org.ops4j.pax.web.descriptor.gen.TrackingModeType;
import org.ops4j.pax.web.descriptor.gen.TrueFalseType;
import org.ops4j.pax.web.descriptor.gen.UrlPatternType;
import org.ops4j.pax.web.descriptor.gen.UserDataConstraintType;
import org.ops4j.pax.web.descriptor.gen.WebAppType;
import org.ops4j.pax.web.descriptor.gen.WebResourceCollectionType;
import org.ops4j.pax.web.descriptor.gen.WelcomeFileListType;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppCookieConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilterMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspPropertyGroup;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityConstraint;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityRole;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletContainerInitializer;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppTagLib;
import org.ops4j.pax.web.extender.war.internal.parser.NamespaceFilter;
import org.ops4j.pax.web.extender.war.internal.parser.WebFilterAnnotationConfigurer;
import org.ops4j.pax.web.extender.war.internal.parser.WebServletAnnotationConfigurer;
import org.ops4j.pax.web.extender.war.internal.util.ManifestUtil;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.ops4j.spi.SafeServiceLoader;
import org.ops4j.util.xml.ElementHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WebAppParser {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppParser.class);
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdmin;

    public WebAppParser(ServiceTracker<PackageAdmin, PackageAdmin> packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public void parse(Bundle bundle, WebApp webApp) throws Exception {
        URL webXmlURL;
        String rootPath = WebAppParser.extractRootPath(bundle);
        if (!rootPath.isEmpty()) {
            rootPath = rootPath + "/";
        }
        Integer majorVersion = 3;
        Enumeration entries = bundle.findEntries(rootPath + "WEB-INF", "web.xml", false);
        URL uRL = webXmlURL = entries != null && entries.hasMoreElements() ? (URL)entries.nextElement() : null;
        if (webXmlURL != null) {
            WebAppType webAppType = this.parseWebXml(webXmlURL);
            majorVersion = this.scanMajorVersion(webAppType);
            if (webAppType != null) {
                if (webAppType.isMetadataComplete() != null) {
                    webApp.setMetaDataComplete(webAppType.isMetadataComplete());
                }
                LOG.debug("metadata-complete is: {}", (Object)webAppType.isMetadataComplete());
            }
            this.parseApp(webAppType, webApp);
        }
        if (!webApp.getMetaDataComplete() && majorVersion != null && majorVersion >= 3) {
            this.servletContainerInitializerScan(bundle, webApp, majorVersion);
            if (Boolean.TRUE.equals(WebAppParser.canSeeClass(bundle, WebServlet.class))) {
                this.servletAnnotationScan(bundle, webApp);
            }
        }
        this.tldScan(bundle, webApp);
        URL jettyWebXmlURL = null;
        Enumeration enums = bundle.findEntries(rootPath + "WEB-INF", "*web*.xml", false);
        while (enums != null && enums.hasMoreElements()) {
            URL url = (URL)enums.nextElement();
            if (!WebAppParser.isJettyWebXml(url)) continue;
            if (jettyWebXmlURL == null) {
                jettyWebXmlURL = url;
                continue;
            }
            throw new IllegalArgumentException("Found multiple jetty web xml descriptors. Aborting");
        }
        List<URL> webFragments = this.scanWebFragments(bundle, webApp);
        webApp.setWebXmlURL(webXmlURL);
        webApp.setJettyWebXmlURL(jettyWebXmlURL);
        webApp.setVirtualHostList(WebAppParser.extractVirtualHostList(bundle));
        webApp.setConnectorList(WebAppParser.extractConnectorList(bundle));
        webApp.setWebFragments(webFragments);
        webApp.setRootPath(rootPath);
    }

    private void parseApp(WebAppType webAppType, WebApp webApp) {
        for (JAXBElement jaxbElement : webAppType.getModuleNameOrDescriptionAndDisplayName()) {
            Object value = jaxbElement.getValue();
            if (value instanceof ParamValueType) {
                ParamValueType contextParam = (ParamValueType)value;
                WebAppParser.parseContextParams(contextParam, webApp);
                continue;
            }
            if (value instanceof FilterType) {
                FilterType filterType = (FilterType)value;
                WebAppParser.parseFilters(filterType, webApp);
                continue;
            }
            if (value instanceof FilterMappingType) {
                FilterMappingType filterMapping = (FilterMappingType)value;
                WebAppParser.parseFilterMappings(filterMapping, webApp);
                continue;
            }
            if (value instanceof ListenerType) {
                ListenerType listener = (ListenerType)value;
                WebAppParser.parseListeners(listener, webApp);
                continue;
            }
            if (value instanceof ServletType) {
                ServletType servlet = (ServletType)value;
                WebAppParser.parseServlets(servlet, webApp);
                continue;
            }
            if (value instanceof ServletMappingType) {
                ServletMappingType servletMapping = (ServletMappingType)value;
                WebAppParser.parseServletMappings(servletMapping, webApp);
                continue;
            }
            if (value instanceof SessionConfigType) {
                SessionConfigType sessionConfig = (SessionConfigType)value;
                WebAppParser.parseSessionConfig(sessionConfig, webApp);
                continue;
            }
            if (value instanceof MimeMappingType) {
                MimeMappingType mimeMapping = (MimeMappingType)value;
                WebAppParser.parseMimeMappings(mimeMapping, webApp);
                continue;
            }
            if (value instanceof WelcomeFileListType) {
                WelcomeFileListType welcomeFileList = (WelcomeFileListType)value;
                if (webApp.getWelcomeFiles().length == 0) {
                    WebAppParser.parseWelcomeFiles(welcomeFileList, webApp);
                    continue;
                }
                LOG.error("duplicate <welcome-file-list>");
                continue;
            }
            if (value instanceof ErrorPageType) {
                ErrorPageType errorPage = (ErrorPageType)value;
                WebAppParser.parseErrorPages(errorPage, webApp);
                continue;
            }
            if (value instanceof JspConfigType) {
                JspConfigType jspConfig = (JspConfigType)value;
                if (webApp.getJspConfigDescriptor() == null) {
                    this.parseJspConfig(jspConfig, webApp);
                    continue;
                }
                LOG.error("duplicate <jsp-config>");
                continue;
            }
            if (value instanceof SecurityConstraintType) {
                SecurityConstraintType securityConstraint = (SecurityConstraintType)value;
                WebAppParser.parseSecurityConstraint(securityConstraint, webApp);
                continue;
            }
            if (value instanceof LoginConfigType) {
                LoginConfigType loginConfig = (LoginConfigType)value;
                if (webApp.getLoginConfigs().length == 0) {
                    WebAppParser.parseLoginConfig(loginConfig, webApp);
                    continue;
                }
                LOG.error("duplicate <login-config>");
                continue;
            }
            if (value instanceof SecurityRoleType) {
                SecurityRoleType securityRole = (SecurityRoleType)value;
                WebAppParser.parseSecurityRole(securityRole, webApp);
                continue;
            }
            if (value instanceof DescriptionType || value instanceof DisplayNameType || value instanceof EmptyType) continue;
            LOG.warn("unhandled element [{}] of type [{}]", (Object)jaxbElement.getName(), (Object)value.getClass().getSimpleName());
        }
    }

    private Integer scanMajorVersion(WebAppType webAppType) {
        String version = webAppType.getVersion();
        Integer majorVersion = null;
        if (version != null && !version.isEmpty() && version.length() > 2) {
            LOG.debug("version found in web.xml - {}", (Object)version);
            try {
                majorVersion = Integer.parseInt(version.split("\\.")[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (version != null && !version.isEmpty() && version.length() > 0) {
            try {
                majorVersion = Integer.parseInt(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return majorVersion;
    }

    private void tldScan(Bundle bundle, WebApp webApp) throws Exception {
        Object paramValue;
        StringBuilder builder;
        Set bundlesInClassSpace = ClassPathUtil.getBundlesInClassSpace((Bundle)bundle, new HashSet());
        ArrayList<URL> taglibs = new ArrayList<URL>();
        ArrayList<Object> facesConfigs = new ArrayList<Object>();
        for (Object u : ClassPathUtil.findResources((Iterable)bundlesInClassSpace, (String)"/", (String)"*.tld", (boolean)true)) {
            InputStream inputStream = ((URL)u).openStream();
            Throwable throwable = null;
            try {
                Element rootTld = ElementHelper.getRootElement(inputStream);
                if (rootTld == null) continue;
                WebAppParser.parseListeners(rootTld, webApp);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        for (Object u : ClassPathUtil.findResources((Iterable)bundlesInClassSpace, (String)"/META-INF", (String)"*.taglib.xml", (boolean)false)) {
            LOG.info("found taglib {}", (Object)((URL)u).toString());
            taglibs.add((URL)u);
        }
        for (Object u : ClassPathUtil.findResources((Iterable)bundlesInClassSpace, (String)"/META-INF", (String)"faces-config.xml", (boolean)false)) {
            LOG.info("found faces-config.xml {}", (Object)((URL)u).toString());
            facesConfigs.add(u);
        }
        if (!taglibs.isEmpty()) {
            builder = new StringBuilder();
            for (URL uRL : taglibs) {
                builder.append(uRL);
                builder.append(";");
            }
            paramValue = builder.toString();
            paramValue = ((String)paramValue).substring(0, ((String)paramValue).length() - 1);
            WebAppInitParam webAppInitParam = new WebAppInitParam();
            webAppInitParam.setParamName("javax.faces.FACELETS_LIBRARIES");
            webAppInitParam.setParamValue((String)paramValue);
            webApp.addContextParam(webAppInitParam);
        }
        if (!facesConfigs.isEmpty()) {
            builder = new StringBuilder();
            for (URL uRL : facesConfigs) {
                builder.append(uRL);
                builder.append(",");
            }
            paramValue = builder.toString();
            paramValue = ((String)paramValue).substring(0, ((String)paramValue).length() - 1);
            WebAppInitParam webAppInitParam = new WebAppInitParam();
            webAppInitParam.setParamName("javax.faces.CONFIG_FILES");
            webAppInitParam.setParamValue((String)paramValue);
            webApp.addContextParam(webAppInitParam);
        }
    }

    private List<URL> scanWebFragments(Bundle bundle, WebApp webApp) throws Exception {
        Set bundlesInClassSpace = ClassPathUtil.getBundlesInClassSpace((Bundle)bundle, new HashSet());
        ArrayList<URL> webFragments = new ArrayList<URL>();
        for (URL webFragmentURL : ClassPathUtil.findResources((Iterable)bundlesInClassSpace, (String)"/META-INF", (String)"web-fragment.xml", (boolean)true)) {
            webFragments.add(webFragmentURL);
            WebAppType webAppType = this.parseWebXml(webFragmentURL);
            this.parseApp(webAppType, webApp);
        }
        return webFragments;
    }

    private void servletAnnotationScan(Bundle bundle, WebApp webApp) throws Exception {
        LOG.debug("metadata-complete is either false or not set");
        LOG.debug("scanning for annotated classes");
        BundleAnnotationFinder baf = new BundleAnnotationFinder((PackageAdmin)this.packageAdmin.getService(), bundle);
        LinkedHashSet webServletClasses = new LinkedHashSet(baf.findAnnotatedClasses(WebServlet.class));
        LinkedHashSet webFilterClasses = new LinkedHashSet(baf.findAnnotatedClasses(WebFilter.class));
        LinkedHashSet webListenerClasses = new LinkedHashSet(baf.findAnnotatedClasses(WebListener.class));
        for (Class webServletClass : webServletClasses) {
            LOG.debug("found WebServlet annotation on class: {}", (Object)webServletClass);
            WebServletAnnotationConfigurer annonScanner = new WebServletAnnotationConfigurer(bundle, webServletClass.getCanonicalName());
            annonScanner.scan(webApp);
        }
        for (Class webFilterClass : webFilterClasses) {
            LOG.debug("found WebFilter annotation on class: {}", (Object)webFilterClass);
            WebFilterAnnotationConfigurer filterScanner = new WebFilterAnnotationConfigurer(bundle, webFilterClass.getCanonicalName());
            filterScanner.scan(webApp);
        }
        for (Class webListenerClass : webListenerClasses) {
            LOG.debug("found WebListener annotation on class: {}", (Object)webListenerClass);
            WebAppParser.addWebListener(webApp, webListenerClass.getCanonicalName());
        }
        LOG.debug("class scanning done");
    }

    private void servletContainerInitializerScan(Bundle bundle, WebApp webApp, Integer majorVersion) throws Exception {
        LOG.debug("scanning for ServletContainerInitializer");
        SafeServiceLoader safeServiceLoader = new SafeServiceLoader(((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
        List containerInitializers = safeServiceLoader.load("javax.servlet.ServletContainerInitializer");
        for (ServletContainerInitializer servletContainerInitializer : containerInitializers) {
            Class<?>[] classes;
            WebAppServletContainerInitializer webAppServletContainerInitializer = new WebAppServletContainerInitializer();
            webAppServletContainerInitializer.setServletContainerInitializer(servletContainerInitializer);
            if (!webApp.getMetaDataComplete() && majorVersion != null && majorVersion >= 3 && (classes = this.getHandledTypes(servletContainerInitializer, bundle)) != null) {
                webAppServletContainerInitializer.setClasses(classes);
            }
            webApp.addServletContainerInitializer(webAppServletContainerInitializer);
        }
    }

    private Class<?>[] getHandledTypes(ServletContainerInitializer servletContainerInitializer, Bundle bundle) {
        try {
            Class loadClass = bundle.loadClass("javax.servlet.annotation.HandlesTypes");
            HandlesTypes handlesTypes = (HandlesTypes)loadClass.cast(servletContainerInitializer.getClass().getAnnotation(loadClass));
            LOG.debug("Found HandlesTypes {}", (Object)handlesTypes);
            return handlesTypes != null ? handlesTypes.value() : null;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("HandlesTypes annotation not present", (Throwable)e);
            return null;
        }
    }

    private static void parseSecurityRole(SecurityRoleType securityRoleType, WebApp webApp) {
        WebAppSecurityRole webSecurityRole = new WebAppSecurityRole();
        String roleName = securityRoleType.getRoleName().getValue();
        webSecurityRole.addRoleName(roleName);
        webApp.addSecurityRole(webSecurityRole);
    }

    private static void parseLoginConfig(LoginConfigType loginConfig, WebApp webApp) {
        WebAppLoginConfig webLoginConfig = new WebAppLoginConfig();
        webLoginConfig.setAuthMethod(loginConfig.getAuthMethod().getValue());
        String realmName = null;
        if (loginConfig.getRealmName() != null) {
            realmName = loginConfig.getRealmName().getValue();
        }
        webLoginConfig.setRealmName(realmName == null ? "default" : realmName);
        if ("FORM".equalsIgnoreCase(webLoginConfig.getAuthMethod())) {
            FormLoginConfigType formLoginConfigElement = loginConfig.getFormLoginConfig();
            webLoginConfig.setFormLoginPage(formLoginConfigElement.getFormLoginPage().getValue());
            webLoginConfig.setFormErrorPage(formLoginConfigElement.getFormErrorPage().getValue());
        }
        webApp.addLoginConfig(webLoginConfig);
    }

    private static void parseSecurityConstraint(SecurityConstraintType securityConstraint, WebApp webApp) {
        try {
            UserDataConstraintType userDataConstraintsElement;
            WebAppSecurityConstraint webSecurityConstraint = new WebAppSecurityConstraint();
            AuthConstraintType authConstraintElement = securityConstraint.getAuthConstraint();
            if (authConstraintElement != null) {
                webSecurityConstraint.setAuthenticate(true);
                for (RoleNameType roleElement : authConstraintElement.getRoleName()) {
                    webSecurityConstraint.addRole(roleElement.getValue());
                }
            }
            if ((userDataConstraintsElement = securityConstraint.getUserDataConstraint()) != null) {
                String guarantee = userDataConstraintsElement.getTransportGuarantee().getValue().toUpperCase();
                webSecurityConstraint.setDataConstraint(guarantee);
            }
            for (WebResourceCollectionType webResourceElement : securityConstraint.getWebResourceCollection()) {
                WebAppSecurityConstraint sc = (WebAppSecurityConstraint)webSecurityConstraint.clone();
                String constraintName = webResourceElement.getWebResourceName().getValue();
                int count = webApp.getConstraintMappings().length;
                for (UrlPatternType urlPatternType : webResourceElement.getUrlPattern()) {
                    String url = urlPatternType.getValue();
                    List httpMethodElements = webResourceElement.getHttpMethod();
                    if (httpMethodElements != null && !httpMethodElements.isEmpty()) {
                        for (String httpMethodElement : httpMethodElements) {
                            WebAppConstraintMapping webConstraintMapping = new WebAppConstraintMapping();
                            webConstraintMapping.setConstraintName(constraintName + "-" + count);
                            webConstraintMapping.setMapping(httpMethodElement);
                            webConstraintMapping.setUrl(url);
                            webConstraintMapping.setSecurityConstraints(sc);
                            webApp.addConstraintMapping(webConstraintMapping);
                            ++count;
                        }
                        continue;
                    }
                    WebAppConstraintMapping webConstraintMapping = new WebAppConstraintMapping();
                    webConstraintMapping.setConstraintName(constraintName + "-" + count);
                    webConstraintMapping.setUrl(url);
                    webConstraintMapping.setSecurityConstraints(sc);
                    webApp.addConstraintMapping(webConstraintMapping);
                    ++count;
                }
            }
        }
        catch (CloneNotSupportedException e) {
            LOG.warn("", (Throwable)e);
        }
    }

    private static void parseContextParams(ParamValueType contextParam, WebApp webApp) {
        WebAppInitParam initParam = new WebAppInitParam();
        initParam.setParamName(contextParam.getParamName().getValue());
        initParam.setParamValue(contextParam.getParamValue().getValue());
        webApp.addContextParam(initParam);
    }

    private static void parseSessionConfig(SessionConfigType sessionConfigType, WebApp webApp) {
        if (sessionConfigType.getSessionTimeout() != null) {
            webApp.setSessionTimeout(sessionConfigType.getSessionTimeout().getValue().toString());
        }
        if (sessionConfigType.getCookieConfig() != null) {
            CookieConfigType cookieConfig = sessionConfigType.getCookieConfig();
            WebAppCookieConfig sessionCookieConfig = new WebAppCookieConfig();
            sessionCookieConfig.setDomain(cookieConfig.getDomain().getValue());
            sessionCookieConfig.setHttpOnly(cookieConfig.getHttpOnly().isValue());
            sessionCookieConfig.setMaxAge(cookieConfig.getMaxAge().getValue().intValue());
            sessionCookieConfig.setName(cookieConfig.getName().getValue());
            sessionCookieConfig.setPath(cookieConfig.getPath().getValue());
            sessionCookieConfig.setSecure(cookieConfig.getSecure().isValue());
            webApp.setSessionCookieConfig(sessionCookieConfig);
        }
        if (sessionConfigType.getTrackingMode() != null) {
            List trackingMode = sessionConfigType.getTrackingMode();
            for (TrackingModeType trackingModeType : trackingMode) {
                String value = trackingModeType.getValue();
                webApp.addSessionTrackingMode(value);
            }
        }
    }

    private static void parseServlets(ServletType servletType, WebApp webApp) {
        MultipartConfigType multipartConfig;
        WebAppServlet servlet = new WebAppServlet();
        servlet.setServletName(servletType.getServletName().getValue());
        if (servletType.getServletClass() != null) {
            servlet.setServletClassName(servletType.getServletClass().getValue());
            webApp.addServlet(servlet);
        } else {
            String jspFile = servletType.getJspFile().getValue();
            if (jspFile != null) {
                WebAppJspServlet jspServlet = new WebAppJspServlet();
                jspServlet.setServletName(servletType.getServletName().getValue());
                jspServlet.setJspPath(jspFile);
                webApp.addServlet(jspServlet);
            }
        }
        servlet.setLoadOnStartup(servletType.getLoadOnStartup());
        if (servletType.getAsyncSupported() != null) {
            servlet.setAsyncSupported(servletType.getAsyncSupported().isValue());
        }
        if ((multipartConfig = servletType.getMultipartConfig()) != null) {
            String location = multipartConfig.getLocation().getValue();
            String maxFileSize = Long.toString(multipartConfig.getMaxFileSize());
            String maxRequestSize = Long.toString(multipartConfig.getMaxRequestSize());
            String fileSizeThreshold = multipartConfig.getFileSizeThreshold().toString();
            MultipartConfigElement multipartConfigElement = new MultipartConfigElement(location, Long.parseLong(maxFileSize), Long.parseLong(maxRequestSize), Integer.parseInt(fileSizeThreshold));
            servlet.setMultipartConfig(multipartConfigElement);
        }
        List servletInitParams = servletType.getInitParam();
        for (ParamValueType initParamElement : servletInitParams) {
            WebAppInitParam initParam = new WebAppInitParam();
            initParam.setParamName(initParamElement.getParamName().getValue());
            initParam.setParamValue(initParamElement.getParamValue().getValue());
            servlet.addInitParam(initParam);
        }
    }

    private static void parseServletMappings(ServletMappingType servletMappingType, WebApp webApp) {
        String servletName = servletMappingType.getServletName().getValue();
        List urlPattern = servletMappingType.getUrlPattern();
        for (UrlPatternType urlPatternElement : urlPattern) {
            WebAppServletMapping servletMapping = new WebAppServletMapping();
            servletMapping.setServletName(servletName);
            servletMapping.setUrlPattern(urlPatternElement.getValue());
            webApp.addServletMapping(servletMapping);
        }
    }

    private static void parseFilters(FilterType filterType, WebApp webApp) {
        WebAppFilter filter = new WebAppFilter();
        if (filterType.getFilterName() != null) {
            filter.setFilterName(filterType.getFilterName().getValue());
        }
        if (filterType.getFilterClass() != null) {
            filter.setFilterClass(filterType.getFilterClass().getValue());
        }
        if (filterType.getAsyncSupported() != null) {
            filter.setAsyncSupported(filterType.getAsyncSupported().isValue());
        }
        webApp.addFilter(filter);
        List initParams = filterType.getInitParam();
        if (initParams != null && initParams.size() > 0) {
            for (ParamValueType initParamElement : initParams) {
                WebAppInitParam initParam = new WebAppInitParam();
                initParam.setParamName(initParamElement.getParamName().getValue());
                initParam.setParamValue(initParamElement.getParamValue().getValue());
                filter.addInitParam(initParam);
            }
        }
        List description = filterType.getDescription();
        for (DescriptionType descriptionType : description) {
            filter.addDispatcherType(javax.servlet.DispatcherType.valueOf((String)descriptionType.getValue()));
        }
    }

    private static void parseFilterMappings(FilterMappingType filterMapping, WebApp webApp) {
        WebAppFilterMapping webAppFilterMapping;
        String filterName = filterMapping.getFilterName().getValue();
        List urlPatternOrServletName = filterMapping.getUrlPatternOrServletName();
        for (Object object : urlPatternOrServletName) {
            if (object instanceof UrlPatternType) {
                UrlPatternType urlPatternType = (UrlPatternType)object;
                webAppFilterMapping = new WebAppFilterMapping();
                webAppFilterMapping.setFilterName(filterName);
                webAppFilterMapping.setUrlPattern(urlPatternType.getValue());
                webApp.addFilterMapping(webAppFilterMapping);
                continue;
            }
            if (!(object instanceof ServletNameType)) continue;
            ServletNameType servletNameType = (ServletNameType)object;
            webAppFilterMapping = new WebAppFilterMapping();
            webAppFilterMapping.setFilterName(filterName);
            webAppFilterMapping.setServletName(servletNameType.getValue());
            webApp.addFilterMapping(webAppFilterMapping);
        }
        List dispatcher = filterMapping.getDispatcher();
        for (DispatcherType dispatcherType : dispatcher) {
            webAppFilterMapping = new WebAppFilterMapping();
            webAppFilterMapping.setFilterName(filterName);
            javax.servlet.DispatcherType displatcher = javax.servlet.DispatcherType.valueOf((String)dispatcherType.getValue());
            EnumSet<javax.servlet.DispatcherType> dispatcherSet = EnumSet.noneOf(javax.servlet.DispatcherType.class);
            dispatcherSet.add(displatcher);
            webAppFilterMapping.setDispatcherTypes(dispatcherSet);
            webApp.addFilterMapping(webAppFilterMapping);
        }
    }

    private static void parseListeners(ListenerType listenerType, WebApp webApp) {
        WebAppParser.addWebListener(webApp, listenerType.getListenerClass().getValue());
    }

    private static void parseListeners(Element rootElement, WebApp webApp) {
        Element[] elements = ElementHelper.getChildren(rootElement, "listener");
        Arrays.stream(elements).forEach(element -> WebAppParser.addWebListener(webApp, WebAppParser.getTextContent(ElementHelper.getChild(element, "listener-class"))));
    }

    private static void parseErrorPages(ErrorPageType errorPageType, WebApp webApp) {
        WebAppErrorPage errorPage = new WebAppErrorPage();
        if (errorPageType.getErrorCode() != null) {
            errorPage.setErrorCode(errorPageType.getErrorCode().getValue().toString());
        }
        if (errorPageType.getExceptionType() != null) {
            errorPage.setExceptionType(errorPageType.getExceptionType().getValue());
        }
        if (errorPageType.getLocation() != null) {
            errorPage.setLocation(errorPageType.getLocation().getValue());
        }
        if (errorPage.getErrorCode() == null && errorPage.getExceptionType() == null) {
            errorPage.setExceptionType("org.ops4j.pax.web.error.error_page.global");
        }
        webApp.addErrorPage(errorPage);
    }

    private static void parseWelcomeFiles(WelcomeFileListType welcomeFileList, WebApp webApp) {
        if (welcomeFileList != null && welcomeFileList.getWelcomeFile() != null && !welcomeFileList.getWelcomeFile().isEmpty()) {
            welcomeFileList.getWelcomeFile().forEach(webApp::addWelcomeFile);
        }
    }

    private static void parseMimeMappings(MimeMappingType mimeMappingType, WebApp webApp) {
        WebAppMimeMapping mimeMapping = new WebAppMimeMapping();
        mimeMapping.setExtension(mimeMappingType.getExtension().getValue());
        mimeMapping.setMimeType(mimeMappingType.getMimeType().getValue());
        webApp.addMimeMapping(mimeMapping);
    }

    private void parseJspConfig(JspConfigType jspConfig, WebApp webApp) {
        List jspPropertyGroup = jspConfig.getJspPropertyGroup();
        List taglib = jspConfig.getTaglib();
        WebAppJspConfig webAppJspConfig = new WebAppJspConfig();
        for (JspPropertyGroupType jspPropertyGroupType : jspPropertyGroup) {
            WebAppJspPropertyGroup webAppJspGroup = new WebAppJspPropertyGroup();
            TrueFalseType elIgnored = jspPropertyGroupType.getElIgnored();
            TrueFalseType scriptingInvalid = jspPropertyGroupType.getScriptingInvalid();
            TrueFalseType isXml = jspPropertyGroupType.getIsXml();
            for (DisplayNameType displayNameType : jspPropertyGroupType.getDisplayName()) {
                webAppJspGroup.addDisplayName(displayNameType.getValue());
            }
            for (UrlPatternType urlPatternType : jspPropertyGroupType.getUrlPattern()) {
                webAppJspGroup.addUrlPattern(urlPatternType.getValue());
            }
            for (PathType includeCoda : jspPropertyGroupType.getIncludeCoda()) {
                webAppJspGroup.addIncludeCode(includeCoda.getValue());
            }
            for (PathType includePrelude : jspPropertyGroupType.getIncludePrelude()) {
                webAppJspGroup.addIncludePrelude(includePrelude.getValue());
            }
            if (elIgnored != null) {
                webAppJspGroup.addElIgnored(elIgnored.isValue());
            }
            if (scriptingInvalid != null) {
                webAppJspGroup.addScrptingInvalid(scriptingInvalid.isValue());
            }
            if (isXml != null) {
                webAppJspGroup.addIsXml(isXml.isValue());
            }
            webAppJspConfig.addJspPropertyGroup(webAppJspGroup);
        }
        for (TaglibType taglibType : taglib) {
            WebAppTagLib webAppTagLib = new WebAppTagLib();
            String tagLibLocation = taglibType.getTaglibLocation().getValue();
            String tagLibUri = taglibType.getTaglibUri().getValue();
            webAppTagLib.addTagLibLocation(tagLibLocation);
            webAppTagLib.addTagLibUri(tagLibUri);
            webAppJspConfig.addTagLibConfig(webAppTagLib);
        }
        webApp.setJspConfigDescriptor(webAppJspConfig);
    }

    private static String getTextContent(Element element) {
        if (element != null) {
            String content = element.getTextContent();
            if (content != null) {
                content = content.trim();
            }
            return content;
        }
        return null;
    }

    private static void addWebListener(WebApp webApp, String clazz) {
        WebAppListener listener = new WebAppListener();
        listener.setListenerClass(clazz);
        webApp.addListener(listener);
    }

    private static String extractRootPath(Bundle bundle) {
        String rootPath = ManifestUtil.getHeader(bundle, "Webapp-Root");
        if (rootPath == null) {
            rootPath = "";
        }
        rootPath = WebAppParser.stripPrefix(rootPath, "/");
        rootPath = WebAppParser.stripSuffix(rootPath, "/");
        rootPath = rootPath.trim();
        return rootPath;
    }

    private static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    private static String stripSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    private static List<String> extractVirtualHostList(Bundle bundle) {
        LinkedList<String> virtualHostList = new LinkedList<String>();
        String virtualHostListAsString = ManifestUtil.getHeader(bundle, "Web-VirtualHosts");
        if (virtualHostListAsString != null && virtualHostListAsString.length() > 0) {
            String[] virtualHostArray;
            for (String virtualHost : virtualHostArray = virtualHostListAsString.split(",")) {
                virtualHostList.add(virtualHost.trim());
            }
        }
        return virtualHostList;
    }

    private static List<String> extractConnectorList(Bundle bundle) {
        LinkedList<String> connectorList = new LinkedList<String>();
        String connectorListAsString = ManifestUtil.getHeader(bundle, "Web-Connectors");
        if (connectorListAsString != null && connectorListAsString.length() > 0) {
            String[] virtualHostArray;
            for (String virtualHost : virtualHostArray = connectorListAsString.split(",")) {
                connectorList.add(virtualHost.trim());
            }
        }
        return connectorList;
    }

    public static Boolean canSeeClass(Bundle bundle, Class<?> clazz) {
        try {
            return bundle.loadClass(clazz.getName()) == clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean isJettyWebXml(URL url) {
        String path = url.getPath();
        boolean match = (path = path.substring(path.lastIndexOf(47) + 1)).matches("jetty[0-9]?-web\\.xml");
        if (match) {
            return true;
        }
        match = path.matches("web-jetty\\.xml");
        return match;
    }

    protected WebAppType parseWebXml(URL url) {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            NamespaceFilter inFilter = new NamespaceFilter("http://xmlns.jcp.org/xml/ns/javaee");
            inFilter.setParent(reader);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WebAppType.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SAXSource source = new SAXSource(inFilter, new InputSource(url.openStream()));
            return (WebAppType)unmarshaller.unmarshal((Source)source, WebAppType.class).getValue();
        }
        catch (IOException | JAXBException | SAXException exc) {
            LOG.error("error parsing web.xml", exc);
            return null;
        }
    }
}

