/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.felix.base.internal.handler;

import com.eclipsesource.jaxrs.publisher.api.ApplicationRegistry;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.opennms.container.web.felix.base.internal.context.ExtServletContext;
import org.opennms.container.web.felix.base.internal.handler.ServletHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RestServletHandler
extends ServletHandler {
    private final BundleContext bundleContext;

    public RestServletHandler(ExtServletContext context, Servlet servlet, String alias, BundleContext bundleContext) {
        super(context, servlet, alias);
        this.bundleContext = bundleContext;
    }

    @Override
    public boolean matches(String uri) {
        boolean matches = super.matches(uri);
        if (matches) {
            return !this.getEndpoints(uri).isEmpty();
        }
        return matches;
    }

    @Override
    protected String getUri(HttpServletRequest req) {
        if (req.getPathInfo() != null && !req.getPathInfo().isEmpty()) {
            return req.getServletPath() + req.getPathInfo();
        }
        return super.getUri(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getEndpoints(String uri) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(ApplicationRegistry.class);
        try {
            ApplicationRegistry applicationRegistry = (ApplicationRegistry)this.bundleContext.getService(serviceReference);
            List<String> list = applicationRegistry.getEndpoints().stream().filter(endpoint -> uri.equals(endpoint) || uri.startsWith((String)endpoint)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.bundleContext.ungetService(serviceReference);
        }
    }
}

