/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.felix.base.internal.handler;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.container.web.felix.base.internal.context.ExtServletContext;
import org.opennms.container.web.felix.base.internal.handler.AbstractHandler;
import org.opennms.container.web.felix.base.internal.handler.FilterConfigImpl;

public final class FilterHandler
extends AbstractHandler
implements Comparable<FilterHandler> {
    private final Filter filter;
    private final Pattern regex;
    private final int ranking;

    public FilterHandler(ExtServletContext context, Filter filter, String pattern, int ranking) {
        super(context);
        this.filter = filter;
        this.ranking = ranking;
        this.regex = Pattern.compile(pattern);
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void init() throws ServletException {
        String name = "filter_" + this.getId();
        FilterConfigImpl config = new FilterConfigImpl(name, this.getContext(), this.getInitParams());
        this.filter.init((FilterConfig)config);
    }

    @Override
    public void destroy() {
        this.filter.destroy();
    }

    public boolean matches(String uri) {
        if (uri == null) {
            uri = "/";
        }
        return this.regex.matcher(uri).matches();
    }

    public void handle(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        boolean matches = this.matches(req.getPathInfo() == null ? req.getServletPath() : req.getPathInfo());
        if (matches) {
            this.doHandle(req, res, chain);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    private void doHandle(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (!this.getContext().handleSecurity(req, res)) {
            res.sendError(403);
        } else {
            this.filter.doFilter((ServletRequest)req, (ServletResponse)res, chain);
        }
    }

    @Override
    public int compareTo(FilterHandler other) {
        return other.ranking - this.ranking;
    }
}

