/* XmpServerSession.java

   COPYRIGHT 2010 KRUPCZAK.ORG, LLC.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA
 
   For more information, visit:
   http://www.krupczak.org/
*/

package org.krupczak.xmp;

import java.net.*;
import java.io.*;
import java.util.Date;
import java.io.UnsupportedEncodingException;
import javax.net.*;
import java.security.*;
import java.security.cert.*;
import javax.net.ssl.*;
import java.util.Scanner;

/**
 * XmpServerSession is used to establish an Xmp protocol listener
 * for use with Xmp clients and servers (agents).  Instantiating
 * an object causes an Xmp listener to be created waiting to accept
 * Xmp protocol connections.  Use this object for receiving Traps or for
 * writing mock agents for testing purposes.  No support for IPv6
 * right now.
 * @author Bobby Krupczak, rdk@krupczak.org
 * @version $Id$
 * @see Xmp
 * @see XmpVar
 * @see XmpMessage
 **/

public class XmpServerSession {

  // default server port
  public static final int defaultServerPort = Xmp.XMP_PORT;
  public static final int STATE_CLOSED = 0;
  public static final int STATE_LISTEN = 1;

  // instance variables *****************************************
  public String serverAddr = "*";
  public int serverPort = 0;
  SocketOpts sockopts;
  SSLServerSocket s;
  int state;
  int msgsIn, msgsOut, bytesIn, bytesOut;
  public boolean dumpPDUs;

  /* constructors */

  // Constructor takes default addr and XMP port

  // default constructor called by others
  public XmpServerSession(SocketOpts sockopts)
  {
      this.sockopts = sockopts;

      serverPort = defaultServerPort;
      msgsIn = 0;
      msgsOut = 0;
      bytesIn = 0;
      bytesOut = 0;
      dumpPDUs = false;

      state = STATE_CLOSED;
      
  }

  // user decided addr and port to bind to and listen on
  public XmpServerSession(SocketOpts sockopts, String addr, int port)
  {
      this(sockopts);

      serverAddr = addr;
      serverPort = port;

      try {
          // for now, we're ignoring addr XXX
          ServerSocket ss;

          ss = sockopts.sslServerSocketFactory.createServerSocket(serverPort);

	  //          s = (SSLServerSocket)(sockopts.sslServerSocketFactory.createServerSocket(serverPort));
	  //sockopts.getMaxBacklog());

          s = (SSLServerSocket)ss;

          s.setReuseAddress(sockopts.getReuseAddr());
          state = STATE_LISTEN;

      } catch (IOException e) {
          state = STATE_CLOSED;
          System.out.println("XmpServerSesion: failed "+e.getMessage());

      }

  }

  // pass an IPv4 address/port to bind to and listen on 
  public XmpServerSession(SocketOpts sockopts, InetAddress addr, int port)
  {
      this(sockopts,addr.toString(),port);

  }

  /* private methods **************************** */
 

  /* manipulate wire headers */


  /* public methods ***************************** */

  // handle the SSL handshake?
  // any reading/writing to/from the socket will initiate
  // and complete SSL handshake; consequently, do we need
  // to get involved in this?


  // listen for a connection, accept it, and then return
  // the new SSLSocket; caller is responsible for
  // threading model -- that is, they hand socket 
  // to a thread or they handle the connection sequentially

  public SSLSocket listenForConnection()
  {
      SSLSocket newSock;

      try {
 
	  newSock = (SSLSocket)s.accept();

          // start the synchronous handshake; when call returns
          // handshake is complete and we should check results
          try { 

             newSock.startHandshake(); 

             // handshake complete; verify client/cert
             SSLSession newSession;

             newSession = newSock.getSession();

          } catch (IOException e) {

             System.out.println("IOException "+e.getMessage());

  	     try { newSock.close(); } catch (IOException e1) { }

          }

      } catch (IOException e) {

          System.out.println("IOException on accept: "+e.getMessage());

          return null;

      }

      System.out.println("listenForConnection: returning connected socket");

      return newSock;
  }

  /** obtain which SSL version/protocol was used for this session **/
  public String getSessionProto() 
  {
      return new String("Unknown proto");

  }

  public int getMessagesIn() { return msgsIn; }
  public int getBytesIn() { return bytesIn; }
  public int getMessagesOut() { return msgsOut; }
  public int getBytesOut() { return bytesOut; }
  public boolean dumpPDUs() { return dumpPDUs; }
  public void setDumpPDUs(boolean val) { dumpPDUs = val; }

} /* class XmpServerSession */
