/* Trapreceiver.java

   COPYRIGHT 2010 KRUPCZAK.ORG, LLC.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA
 
   For more information, visit:
   http://www.krupczak.org/
*/

package org.krupczak.xmp;

import java.net.*;
import java.io.*;
import java.security.*;
import java.security.cert.*;
import javax.net.ssl.*;

/**
 *  XMP Trap receiver 
 *  @author Bobby Krupczak, rdk@krupczak.org
 *  @version $Id$
 *  @see XmpSession
 *  @see XmpMessage
 *  @see XmpServerSession
 *  @see Xmp
 **/

public class Trapreceiver {

    private static void usage(String argv[]) {

	System.out.println("Usage: java Trapreceiver port keystore");
        System.exit(-1);

    } /* usage */

    public static void main(String argv[]) 
    {
        int i,port;
        XmpServerSession session;
        SocketOpts sockopts;
        SSLSocket aSocket;
        String keyStoreFile;

        /* java and program name are not part of argv */
        if (argv.length < 2)
	    usage(argv);

        sockopts = new SocketOpts();

        port = Integer.valueOf(argv[0]).intValue();

        System.out.println("XMP Trap receiver listening on port "+port);

        session = new XmpServerSession(sockopts,"*",port);

        aSocket = session.listenForConnection();


    } /* main */

} /* class Trapreceiver */
