/* Queryxmp.java

   COPYRIGHT 2004,8 KRUPCZAK.ORG, LLC.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA
 
   For more information, visit:
   http://www.krupczak.org/
*/

package org.krupczak.xmp;

import java.net.*;
import java.io.*;
import java.security.*;
import java.security.cert.*;
import javax.net.ssl.*;


/**
 * Query XMP agent using template PDUs 
 *  @author Bobby Krupczak, rdk@krupczak.org
 *  @version $Id: Queryxmp.java 15 2008-07-17 14:20:37Z rdk $
 *  @see XmpSession
 *  @see XmpMessage
 *  @see Xmp
 **/

public class Queryxmp {

    private static void usage(String argv[]) {

	System.out.println("Usage: java Queryxmp target authenUser query(s)");
        System.exit(-1);

    } /* usage */

    private static String readQueryFile(String filename) {
         File inputFile;
         FileInputStream in;
         byte[] buf;
         int len;

         try {
           inputFile = new File(filename);
           in = new FileInputStream(inputFile);
           buf = new byte[(int)inputFile.length()];

           /* read file into expandable array */
           len = in.read(buf,0,buf.length);

         }
         catch (IOException e) { System.out.println("Null query file"); return null; }

         return new String(buf);
    }

    public static void main(String argv[]) {
        int i;
        XmpSession session;
        String aString,aReply;
        SocketOpts sockopts;

        /* java and program name are not part of argv */
        if (argv.length < 3)
	    usage(argv);

        sockopts = new SocketOpts();

        session = new XmpSession(sockopts,argv[0],Xmp.XMP_PORT,argv[1]);
        if (session.isOpen())
           System.out.println("Queryxmp: connected to " + argv[0]);
        else
           System.out.println("Queryxmp: not connected to " + argv[0]);

        /* for each file, send file, wait for
           reply */
        for (i=2; i< argv.length; i++) {
            aString = readQueryFile(argv[i]);
            aReply = session.sendMessageReceiveReply(aString);

            if (aReply != null) {
               System.out.println("Queryxmp: received reply "+ aReply.length() +" bytes");
               System.out.print(aReply);
            }
            else {
	       System.out.println("Queryxmp: null reply");
            }
        }

    } /* main */

} /* class Queryxmp */
