/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jasperreports;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractMultiClassCompiler;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class MavenJavacCompiler
extends JRAbstractMultiClassCompiler {
    private static Log log;
    private static String compilerId;
    private static Compiler compiler;
    private static Toolchain tc;
    private static boolean debug;
    private static String encoding;
    private static String sourceVersion;
    private static String targetVersion;
    private boolean fork = false;
    private String executable = null;

    public static Log getLog() {
        return log;
    }

    public static void init(Log log, Compiler compiler, boolean debug, String encoding, Toolchain tc, String sourceVersion, String targetVersion) {
        MavenJavacCompiler.log = log;
        MavenJavacCompiler.compiler = compiler;
        MavenJavacCompiler.debug = debug;
        MavenJavacCompiler.encoding = encoding;
        MavenJavacCompiler.tc = tc;
        MavenJavacCompiler.sourceVersion = sourceVersion;
        MavenJavacCompiler.targetVersion = targetVersion;
    }

    public MavenJavacCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    public MavenJavacCompiler() {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance());
    }

    public String compileClasses(File[] sourceFiles, String classpath) throws JRException {
        List messages;
        Toolchain tc = MavenJavacCompiler.getToolchain();
        if (tc != null) {
            MavenJavacCompiler.getLog().info((CharSequence)("Toolchain in compiler-plugin: " + tc));
            if (this.executable != null) {
                MavenJavacCompiler.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            } else {
                this.fork = true;
                this.executable = tc.findTool(compilerId);
            }
        }
        ArrayList<String> classpathAsList = new ArrayList<String>(Arrays.asList(classpath.split(",")));
        HashSet<File> sourceFilesAsSet = new HashSet<File>(Arrays.asList(sourceFiles));
        if (MavenJavacCompiler.getLog().isDebugEnabled()) {
            MavenJavacCompiler.getLog().debug((CharSequence)("Classpath: " + classpath.replace(',', '\n')));
        }
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setClasspathEntries(classpathAsList);
        compilerConfiguration.setOutputLocation(sourceFiles[0].getParent());
        compilerConfiguration.setWorkingDirectory(sourceFiles[0].getParentFile());
        compilerConfiguration.setSourceFiles(sourceFilesAsSet);
        compilerConfiguration.setDebug(debug);
        compilerConfiguration.setSourceEncoding(encoding);
        compilerConfiguration.setSourceVersion(sourceVersion);
        compilerConfiguration.setTargetVersion(targetVersion);
        compilerConfiguration.setFork(this.fork);
        compilerConfiguration.setExecutable(this.executable);
        if (MavenJavacCompiler.getLog().isDebugEnabled()) {
            try {
                String[] cl;
                if (this.fork && compilerConfiguration.getExecutable() != null) {
                    MavenJavacCompiler.getLog().debug((CharSequence)"Excutable: ");
                    MavenJavacCompiler.getLog().debug((CharSequence)(" " + compilerConfiguration.getExecutable()));
                }
                if ((cl = compiler.createCommandLine(compilerConfiguration)) != null && cl.length > 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(cl[0]);
                    for (int i = 1; i < cl.length; ++i) {
                        sb.append(" ");
                        sb.append(cl[i]);
                    }
                    MavenJavacCompiler.getLog().debug((CharSequence)"Command line options:");
                    MavenJavacCompiler.getLog().debug((CharSequence)sb);
                }
            }
            catch (CompilerException ce) {
                MavenJavacCompiler.getLog().debug((Throwable)ce);
            }
        }
        if (StringUtils.isEmpty((String)compilerConfiguration.getSourceEncoding())) {
            MavenJavacCompiler.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        try {
            messages = compiler.compile(compilerConfiguration);
        }
        catch (Exception e) {
            throw new JRException("Fatal error compiling", (Throwable)e);
        }
        ArrayList<CompilerError> warnings = new ArrayList<CompilerError>();
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        if (messages != null) {
            for (CompilerError message : messages) {
                if (message.isError()) {
                    errors.add(message);
                    continue;
                }
                warnings.add(message);
            }
        }
        if (!errors.isEmpty()) {
            if (!warnings.isEmpty()) {
                MavenJavacCompiler.getLog().info((CharSequence)"-------------------------------------------------------------");
                MavenJavacCompiler.getLog().warn((CharSequence)"COMPILATION WARNING : ");
                MavenJavacCompiler.getLog().info((CharSequence)"-------------------------------------------------------------");
                for (CompilerError warning : warnings) {
                    MavenJavacCompiler.getLog().warn((CharSequence)warning.toString());
                }
                MavenJavacCompiler.getLog().info((CharSequence)(warnings.size() + (warnings.size() > 1 ? " warnings " : "warning")));
                MavenJavacCompiler.getLog().info((CharSequence)"-------------------------------------------------------------");
            }
            MavenJavacCompiler.getLog().info((CharSequence)"-------------------------------------------------------------");
            MavenJavacCompiler.getLog().error((CharSequence)"COMPILATION ERROR : ");
            MavenJavacCompiler.getLog().info((CharSequence)"-------------------------------------------------------------");
            for (CompilerError error : errors) {
                MavenJavacCompiler.getLog().error((CharSequence)error.toString());
            }
            MavenJavacCompiler.getLog().info((CharSequence)(errors.size() + (errors.size() > 1 ? " errors " : "error")));
            MavenJavacCompiler.getLog().info((CharSequence)"-------------------------------------------------------------");
            throw new JRException("Error compiling report");
        }
        for (CompilerError message : messages) {
            MavenJavacCompiler.getLog().warn((CharSequence)message.toString());
        }
        return null;
    }

    private static Toolchain getToolchain() {
        return tc;
    }

    static {
        compilerId = "javac";
    }
}

