/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jasperreports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public class JasperReportsMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenSession session;
    private File javaDirectory;
    private File outputDirectory;
    private File sourceDirectory;
    private String sourceFileExt;
    private String outputFileExt;
    private boolean keepJava;
    private boolean keepSerializedObject;
    private boolean xmlValidation;
    private String compiler;
    private List classpathElements;
    private Map additionalProperties = new HashMap();
    private String additionalClasspath;
    private CompilerManager compilerManager;
    private ToolchainManager toolchainManager;
    protected String source;
    protected String target;
    private String encoding;
    private boolean debug = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("javaDir = " + this.javaDirectory));
        this.getLog().debug((CharSequence)("sourceDirectory = " + this.sourceDirectory));
        this.getLog().debug((CharSequence)("sourceFileExt = " + this.sourceFileExt));
        this.getLog().debug((CharSequence)("targetDirectory = " + this.outputDirectory));
        this.getLog().debug((CharSequence)("targetFileExt = " + this.outputFileExt));
        this.getLog().debug((CharSequence)("keepJava = " + this.keepJava));
        this.getLog().debug((CharSequence)("xmlValidation = " + this.xmlValidation));
        this.getLog().debug((CharSequence)("compiler = " + this.compiler));
        this.getLog().debug((CharSequence)("classpathElements = " + this.classpathElements));
        this.getLog().debug((CharSequence)("additionalClasspath = " + this.additionalClasspath));
        this.checkDir(this.javaDirectory, "Directory for generated java sources", true);
        this.checkDir(this.sourceDirectory, "Source directory", false);
        this.checkDir(this.outputDirectory, "Target directory", true);
        SuffixMapping mapping = new SuffixMapping(this.sourceFileExt, this.outputFileExt);
        Set staleSources = this.scanSrcDir((SourceMapping)mapping);
        if (staleSources.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to compile - all Jasper reports are up to date");
        } else {
            this.compile(staleSources, (SourceMapping)mapping);
            if (this.keepJava) {
                this.project.addCompileSourceRoot(this.javaDirectory.getAbsolutePath());
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void compile(Set files, SourceMapping mapping) throws MojoFailureException, MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getFileMd5(File src) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        FileInputStream sourceIs = new FileInputStream(src);
        byte[] dataBytes = new byte[1024];
        int nread = 0;
        while ((nread = sourceIs.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        byte[] mdbytes = md.digest();
        StringBuffer srcMd5 = new StringBuffer();
        for (int i = 0; i < mdbytes.length; ++i) {
            srcMd5.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        String srcMd5String = srcMd5.toString();
        return srcMd5String;
    }

    protected Set scanSrcDir(SourceMapping mapping) throws MojoExecutionException {
        boolean staleMillis = false;
        StaleSourceScanner scanner = new StaleSourceScanner(0L);
        scanner.addSourceMapping(mapping);
        try {
            return scanner.getIncludedSources(this.sourceDirectory, this.outputDirectory);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + this.sourceDirectory + "' " + "for stale files to recompile.", (Exception)((Object)e));
        }
    }

    private String getPathRelativeToRoot(File file) throws MojoExecutionException {
        try {
            String root = this.sourceDirectory.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (!filePath.startsWith(root)) {
                throw new MojoExecutionException("File is not in source root ??? " + file);
            }
            return filePath.substring(root.length() + 1);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not getCanonicalPath from file " + file, (Exception)e);
        }
    }

    protected String buildClasspathString(List classpathElements, String additionalClasspath) {
        StringBuffer classpath = new StringBuffer();
        Iterator it = classpathElements.iterator();
        while (it.hasNext()) {
            String cpElement = (String)it.next();
            classpath.append(cpElement);
            if (!it.hasNext()) continue;
            classpath.append(File.pathSeparator);
        }
        if (additionalClasspath != null) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(additionalClasspath);
        }
        return classpath.toString();
    }

    private void checkDir(File dir, String desc, boolean isTarget) throws MojoExecutionException {
        if (dir.exists() && !dir.isDirectory()) {
            throw new MojoExecutionException(desc + " is not a directory : " + dir);
        }
        if (!dir.exists() && isTarget && !dir.mkdirs()) {
            throw new MojoExecutionException(desc + " could not be created : " + dir);
        }
        if (isTarget && !dir.canWrite()) {
            throw new MojoExecutionException(desc + " is not writable : " + dir);
        }
    }

    private ClassLoader getClassLoader(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<URL> classpathURLs = new ArrayList<URL>();
        for (int i = 0; i < this.classpathElements.size(); ++i) {
            String element = (String)this.classpathElements.get(i);
            try {
                File f = new File(element);
                URL newURL = f.toURI().toURL();
                classpathURLs.add(newURL);
                this.getLog().debug((CharSequence)("Added to classpath " + element));
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error parsing classparh " + element + " " + e.getMessage());
            }
        }
        if (this.additionalClasspath != null && this.additionalClasspath.length() > 0) {
            String[] elements = this.additionalClasspath.split(File.pathSeparator);
            for (int i = 0; i < elements.length; ++i) {
                String element = elements[i];
                try {
                    File f = new File(element);
                    URL newURL = f.toURI().toURL();
                    classpathURLs.add(newURL);
                    this.getLog().debug((CharSequence)("Added to classpath " + element));
                    continue;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error parsing classpath " + this.additionalClasspath + " " + e.getMessage());
                }
            }
        }
        URL[] urls = classpathURLs.toArray(new URL[classpathURLs.size()]);
        return new URLClassLoader(urls, classLoader);
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }
}

