/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


package com.google.gwt.maps.utility.client.snapshotcontrol;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.client.overlay.Marker;

/**
 * Defines snapshot style attributes for Marker.
 */
public class SnapShotMarkerStyle extends JavaScriptObject {

  /**
   * Constructs a Marker snapshot style.
   * 
   * @return A SnapShotMarkerStyle object.
   */
  public native static SnapShotMarkerStyle newInstance() /*-{
    return {};
  }-*/;
  
  /**
   * Constructs a Marker snapshot style.
   * 
   * @param character The style's marker contents.
   * @param color The style's marker color.
   * @param size The style's marker size (mid, tiny, small...).
   * @return A SnapShotMarkerStyle object.
   */
  public native static SnapShotMarkerStyle newInstance(String character,
      String color, String size) /*-{
    return {
      ssColor: color,
      ssCharacter: character,
      ssSize: size
    };
  }-*/;
  
  protected SnapShotMarkerStyle() { }
  
  /**
   * Applies the style to the specified Marker.
   * 
   * @param polyline The Marker to which to apply the style.
   */
  public final native void applyTo(Marker marker) /*-{
    var p = @com.google.gwt.maps.utility.client.impl.MapsHelper::getOverlayPeer(Lcom/google/gwt/maps/client/overlay/Overlay;)(marker);
    if (this.ssColor !== undefined) p.ssColor = this.ssColor;
    if (this.ssCharacter !== undefined) p.ssCharacter = this.ssCharacter;
    if (this.ssSize !== undefined) p.ssSize = this.ssSize;
  }-*/;
  
  /**
   * Retrieves the style's marker contents.
   * 
   * @return The style's marker contents.
   */
  public final native String getContents() /*-{
    return this.ssCharacter;
  }-*/;
  
  /**
   * Retrieves the style's marker color.
   * 
   * @return The style's marker color.
   */
  public final native String getColor() /*-{
    return this.ssColor;
  }-*/;
  
  /**
   * Retrieves the style's marker size (mid, tiny, small...).
   * 
   * @return The style's marker size.
   */
  public final native String getSize() /*-{
    return this.ssSize;
  }-*/;
  
  /**
   * Sets the style's marker contents.
   * 
   * @param character The style's marker contents.
   */
  public final native void setContents(String contents) /*-{
    this.ssCharacter = contents;
  }-*/;
  
  /**
   * Sets the style's marker color.
   * 
   * @param color The style's marker color.
   */
  public final native void setColor(String color) /*-{
    this.ssColor = color;
  }-*/;
  
  /**
   * Sets the style's marker size  (mid, tiny, small...).
   * 
   * @param size The style's marker size.
   */
  public final native void setSize(String size) /*-{
    this.ssSize = size;
  }-*/;
  
}
