/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.snapshotcontrol;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * Defines optional arguments to SnapShotControl.
 */
public class SnapShotControlOptions extends JavaScriptObject {

  /**
   * Constructs a SnapShotControl options object.
   * 
   * @return A SnapShotControlOptions object.
   */
  public static native SnapShotControlOptions newInstance() /*-{
    return {
      buttonLabelHtml: 'Say cheese!',
      format: 'gif',
      hidden: false,
      language: '',
      maptype: '',
      mobile: false,
      useAutoDetectMarker: true,
      usePolylineEncode: false
    };
  }-*/;

  protected SnapShotControlOptions() { }

  /**
   * Retrieves the HTML contents of the button control.
   * The default value is  "Say cheese!".
   * 
   * @return The HTML contents of the button control.
   */
  public final native String getButtonLabelHtml() /*-{
    return this.buttonLabelHtml;
  }-*/;
  
  /**
   * Retrieves the image format for snapshot. You can choose one from "gif", 
   * "jpg", "jpg-baseline", "png8", "png32".
   * The default value is "gif".
   * 
   * @return The image format for snapshot.
   */
  public final native String getFormat() /*-{
    return this.format;
  }-*/;
  
  /**
   * Retrieves the control's visibility. If it is set to true, the button is
   * hidden. The default value is false.
   * 
   * @return The control's visibility.
   */
  public final native boolean getHidden() /*-{
    return this.hidden;
  }-*/;
  
  /**
   * Retrieves the language for the snapshot's copyright text.
   * If it is not set, then this library detects the language of the map.
   * The default value is "".
   * 
   * @return The language for the snapshot's copyright text.
   */
  public final native String getLanguage() /*-{
    return this.language;
  }-*/;
  
  /**
   * Retrieves the map type for the snapshot.
   * The options are "roadmap", "satellite", "hybrid" and "terrain".
   * If it is not set, then the control detects the type of the map.
   * The default value is "".
   * 
   * @return The map type for the snapshot.
   */
  public final native String getMapType() /*-{
    return this.maptype;
  }-*/;

  /**
   * Retrieves whether to use mobile-optimized tiles for snapshot.
   * Useful for mobile devices.
   * This property is ignored, when the style property is not set to "roadmap".
   * The default value is false.
   * 
   * @return Whether to use mobile-optimized tiles for snapshot.
   */
  public final native boolean getMobile() /*-{
    return this.mobile;
  }-*/;
  
  /**
   * Retrieves whether the control should attempt to auto detect the marker
   * color, label and size based on standard image naming conventions.
   * The default value is true.
   * 
   * @return Whether to use auto-detect.
   */
  public final native boolean getUseAutoDetectMarker() /*-{
    return this.useAutoDetectMarker;
  }-*/;
  
  /**
   * Retrieves whether to use encoded polys in the snapshot.
   * Useful if you're sending in a big poly and want to stay within URL limits.
   * The default value is false.
   * 
   * @return Whether to use encoded polys in the snapshot.
   */
  public final native boolean getUsePolylineEncode() /*-{
    return this.usePolylineEncode;
  }-*/;

  /**
   * Sets the HTML contents of the button control.
   * The default value is  "Say cheese!".
   * 
   * @param buttonLabelHtml The HTML contents of the button control.
   */
  public final native void setButtonLabelHtml(String buttonLabelHtml) /*-{
    this.buttonLabelHtml = buttonLabelHtml;
  }-*/;

  /**
   * Sets the image format for snapshot. You can choose one from "gif", 
   * "jpg", "jpg-baseline", "png8", "png32".
   * The default value is "gif".
   * 
   * @param format The image format for snapshot.
   */
  public final native void setFormat(String format) /*-{
    this.format = format;
  }-*/;

  /**
   * Sets the control's visibility. If it is set to true, the button is
   * hidden. The default value is false.
   * 
   * @param hidden The control's visibility.
   */
  public final native void setHidden(boolean hidden) /*-{
    this.hidden = hidden;
  }-*/;

  /**
   * Sets the language for the snapshot's copyright text.
   * If it is not set, then this library detects the language of the map.
   * The default value is "".
   * 
   * @param language The language for the snapshot's copyright text.
   */
  public final native void setLanguage(String language) /*-{
    this.language = language;
  }-*/;

  /**
   * Sets the map type for the snapshot.
   * The options are "roadmap", "satellite", "hybrid" and "terrain".
   * If it is not set, then the control detects the type of the map.
   * The default value is "".
   * 
   * @param maptype The map type for the snapshot.
   */
  public final native void setMapType(String maptype) /*-{
    this.maptype = maptype;
  }-*/;

  /**
   * Sets whether to use mobile-optimized tiles for snapshot.
   * Useful for mobile devices.
   * This property is ignored, when the style property is not set to "roadmap".
   * The default value is false.
   * 
   * @param mobile Whether to use mobile-optimized tiles for snapshot.
   */
  public final native void getMobile(boolean mobile) /*-{
    this.mobile = mobile;
  }-*/;

  /**
   * Sets whether the control should attempt to auto detect the marker
   * color, label and size based on standard image naming conventions.
   * The default value is true.
   * 
   * @param useAutoDetectMarker Whether to use auto-detect.
   */
  public final native void getUseAutoDetectMarker(boolean useAutoDetectMarker) /*-{
    this.useAutoDetectMarker = useAutoDetectMarker;
  }-*/;

  /**
   * Sets whether to use encoded polys in the snapshot.
   * Useful if you're sending in a big poly and want to stay within URL limits.
   * The default value is false.
   * 
   * @param usePolylineEncode Whether to use encoded polys in the snapshot.
   */
  public final native void getUsePolylineEncode(boolean usePolylineEncode) /*-{
    this.usePolylineEncode = usePolylineEncode;
  }-*/;
}