/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.progressbarcontrol;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * Defines optional arguments to Progressbar.
 */
public class ProgressbarOptions extends JavaScriptObject {

  /**
   * Constructs a ProgressbarControl options object.
   * 
   * @return A ProgressbarOptions object.
   */
  public static native ProgressbarOptions newInstance() /*-{
    return {
      loadstring: "Loading...",
      width: 176
    };
  }-*/;

  /**
   * Constructs a Progressbar options object.
   * 
   * @param loadString The text to display.
   * @param width The width of the progress bar.
   * @return A ProgressbarOptions object.
   */
  public static native ProgressbarOptions newInstance(
      String loadString,int width) /*-{
    return {
      loadstring: loadString,
      width: width
    };
  }-*/;
  
  protected ProgressbarOptions() { }
  
  /**
   * Retrieves the string displayed when first starting the control, before any
   * update. The default value is "Loading...".
   * 
   * @return The text to display.
   */
  public final native String getLoadString() /*-{
    return this.loadstring;
  }-*/;
  
  /**
   * Retrieves, in pixels, the width of the bar. The default value is 176.
   * 
   * @return The width of the progress bar.
   */
  public final native int getWidth() /*-{
    return this.width || 0;
  }-*/;

  /**
   * Sets the string displayed when first starting the control, before any
   * update. The default value is "Loading...".
   * 
   * @param loadString The text to display.
   */
  public final native void setLoadString(String loadString) /*-{
    this.loadstring = loadString;
  }-*/;
  
  /**
   * Sets, in pixels, the width of the bar. The default value is 176.
   * 
   * @param width The width of the progress bar.
   */
  public final native void setWidth(int width) /*-{
    this.width = width;
  }-*/;

}