/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.progressbarcontrol;

import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.control.Control;
import com.google.gwt.maps.utility.client.impl.ProgressbarControlImpl;

/**
 * A progress bar control for usage in google maps.
 * It can be used to show the progress of loading markers, for example.
 */
public class ProgressbarControl extends Control {

  /**
   * Creates a ProgressbarControl control on the given map, with the given
   * options.
   * 
   * @param map The map in which to display the progress bar.
   */
  public ProgressbarControl(MapWidget map) {
    super(ProgressbarControlImpl.newInstance(map));
  }

  /**
   * Creates a ProgressbarControl control on the given map, with the given
   * options.
   * 
   * @param map The map in which to display the progress bar.
   * @param options The progress bar options.
   */
  public ProgressbarControl(MapWidget map,
      ProgressbarOptions options) {
    super(ProgressbarControlImpl.newInstance(map, options));
  }
  
  /**
   * Remove this progress bar control from the map.
   */
  public void remove() {
    ((ProgressbarControlImpl)this.jsoPeer).remove();
  }
  
  /**
   * Start the progress bar.
   * 
   * @param operations The maximum number of operations.
   */
  public void start(int operations) {
    ((ProgressbarControlImpl)this.jsoPeer).start(operations);
  }
  
  /**
   * Update the progress with specified number of operations.
   * 
   * @param step The number of completed operations.
   */
  public void updateLoader(int step) {
    ((ProgressbarControlImpl)this.jsoPeer).updateLoader(step);
  }
}