/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.popupmarker;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * Defines optional chart arguments for PopupMarker.
 */
public class PopupMarkerChartApiOptions extends JavaScriptObject {

  /**
   * Constructs a PopupMarker chart options object.
   * 
   * @return A PopupMarkerChartApiOptions object.
   */
  public static native PopupMarkerChartApiOptions newInstance() /*-{
    return {
      bgColor: "FFFFFF",
      textColor: "000000"
    };
  }-*/;

  /**
   * Constructs a PopupMarker chart options object.
   * 
   * @param bgColor The background color.
   * @param chartStyle Specifies the chart layout/size.
   * @param icon The icon name.
   * @param textColor The text color.
   * @return A PopupMarkerChartApiOptions object.
   */
  public static native PopupMarkerChartApiOptions newInstance(String bgColor,
      String chartStyle, String icon, String textColor) /*-{
    return {
      bgColor: bgColor,
      chartStyle: chartStyle,
      icon: icon,
      textColor: textColor
    };
  }-*/;
  
  protected PopupMarkerChartApiOptions() { }

  /**
   * Retrieves the background color as a 6-digit hexadecimal number.
   * The default value is "FFFFFF".
   * 
   * @return The background color.
   */
  public final native String getBgColor() /*-{
    return this.bgColor;
  }-*/;

  /**
   * Retrieves the layout/size. Valid options are "d_bubble_icon_text_small",
   * "d_bubble_icon_text_big", "d_bubble_icon_texts_big", and
   * "d_bubble_texts_big".
   * 
   * @return Specifies the chart layout/size.
   */
  public final native String getChartStyle() /*-{
    return this.chartStyle;
  }-*/;
  
  /**
   * Retrieves the icon name. Valid options are shown at
   * http://groups.google.com/group/google-chart-api/web/chart-types-for-information-bubbles#large_icons.
   * 
   * @return The icon name.
   */
  public final native String getIcon() /*-{
    return this.icon;
  }-*/;

  /**
   * Retrieves the text color as a 6-digit hexadecimal number.
   * The default value is "000000".
   * 
   * @return The text color.
   */
  public final native String getTextColor() /*-{
    return this.textColor;
  }-*/;
  
  /**
   * Sets the background color as a 6-digit hexadecimal number.
   * The default value is "FFFFFF".
   * 
   * @param bgColor The background color.
   */
  public final native void setBgColor(String bgColor) /*-{
    this.bgColor = bgColor;
  }-*/;

  /**
   * Sets the layout/size. Valid options are "d_bubble_icon_text_small",
   * "d_bubble_icon_text_big", "d_bubble_icon_texts_big", and
   * "d_bubble_texts_big".
   * 
   * @param chartStyle Specifies the chart layout/size.
   */
  public final native void setChartStyle(String chartStyle) /*-{
    this.chartStyle = chartStyle;
  }-*/;
  
  /**
   * Sets the icon name. Valid options are shown at
   * http://groups.google.com/group/google-chart-api/web/chart-types-for-information-bubbles#large_icons.
   * 
   * @param icon The icon name.
   */
  public final native void setIcon(String icon) /*-{
    this.icon = icon;
  }-*/;

  /**
   * Sets the text color as a 6-digit hexadecimal number.
   * The default value is "000000".
   * 
   * @param textColor The text color.
   */
  public final native void setTextColor(String textColor) /*-{
    this.textColor = textColor;
  }-*/;
  
}