/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.popupmarker;

import com.google.gwt.maps.client.geom.LatLng;
import com.google.gwt.maps.client.overlay.Marker;
import com.google.gwt.maps.utility.client.impl.PopupMarkerImpl;

/**
 * A popup marker.
 */
public class PopupMarker extends Marker {

  /**
   * Creates a marker at the specified position.
   * 
   * @param point The marker position.
   */
  public PopupMarker(LatLng point) {
    super(PopupMarkerImpl.newInstance(point));
  }

  /**
   * Creates a marker at the specified position, with the specified options.
   * 
   * @param point The marker position.
   * @param options The marker options.
   */
  public PopupMarker(LatLng point, PopupMarkerOptions options) {
    super(PopupMarkerImpl.newInstance(point, options));
  }

  /**
   * Hides the marker and popup.
   */
  public void hide() {
    ((PopupMarkerImpl) this.jsoPeer).hide();
  }
  
  /**
   * Hides the popup.
   */
  public void hidePopup() {
    ((PopupMarkerImpl) this.jsoPeer).hidePopup();
  }
  
  /**
   * Sets the background color. If the style property not set to "chart",
   * then this property is ignored.
   * 
   * @param bgColor The background color.
   */
  public void setChartBgColor(String bgColor) {
    ((PopupMarkerImpl) this.jsoPeer).setChartBgColor(bgColor);
  }
  
  /**
   * Sets the icon name. If the style property not set to "chart", then this
   * property is ignored.
   * 
   * @param iconName The icon name.
   */
  public void setChartIcon(String iconName) {
    ((PopupMarkerImpl) this.jsoPeer).setChartIcon(iconName);
  }
  
  /**
   * Sets the chart style. If the style property not set to "chart", then this
   * property is ignored.
   * 
   * @param styleName The chart style.
   */
  public void setChartStyle(String styleName) {
    ((PopupMarkerImpl) this.jsoPeer).setChartStyle(styleName);
  }
  
  /**
   * Sets the chart text color. If the style property not set to "chart", then
   * this property is ignored.
   * 
   * @param textColor The text color.
   */
  public void setChartTextColor(String textColor) {
    ((PopupMarkerImpl) this.jsoPeer).setChartTextColor(textColor);
  }
  
  /**
   * Set the text of the popup message.
   * 
   * @param message The popup message text.
   */
  public void setText(String message) {
    ((PopupMarkerImpl) this.jsoPeer).setText(message);
  }
  
  /**
   * Shows the marker. Note that this method shows only the marker.
   * If you want to show marker and the popup, then use showPopup.
   */
  public void show() {
    ((PopupMarkerImpl) this.jsoPeer).show();
  }
  
  /**
   * Shows the marker and the popup.
   */
  public void showPopup() {
    ((PopupMarkerImpl) this.jsoPeer).showPopup();
  }
  
}