/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.markertracker;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.overlay.Marker;

/**
 * Displays directional indicators for markers as they move out of view. 
 */
public class MarkerTracker extends JavaScriptObject {

  /**
   * Constructs a new MarkerTracker.
   * 
   * @param marker The marker to be tracked.
   * @param map The map containing the marker to be tracked.
   * @return A MarkerTracker object.
   */
  public static native MarkerTracker newInstance(Marker marker, MapWidget map) /*-{
    return new $wnd.MarkerTracker(
      @com.google.gwt.maps.utility.client.impl.MapsHelper::getOverlayPeer(Lcom/google/gwt/maps/client/overlay/Overlay;)(marker),
      map.@com.google.gwt.maps.client.MapWidget::getPeer()()
    );
  }-*/;

  /**
   * Constructs a new MarkerTracker.
   * 
   * @param marker The marker to be tracked.
   * @param map The map containing the marker to be tracked.
   * @param options The marker tracker options.
   * @return A MarkerTracker object.
   */
  public static native MarkerTracker newInstance(Marker marker, MapWidget map,
      MarkerTrackerOptions options) /*-{
    return new $wnd.MarkerTracker(
      @com.google.gwt.maps.utility.client.impl.MapsHelper::getOverlayPeer(Lcom/google/gwt/maps/client/overlay/Overlay;)(marker),
      map.@com.google.gwt.maps.client.MapWidget::getPeer()(),
      options
    );
  }-*/;

  protected MarkerTracker() { }
  
  /**
   * Disables the marker tracker.
   */
  public final native void disable() /*-{
    this.disable();
  }-*/;
  
  /**
   * Enables the marker tracker.
   */
  public final native void enable() /*-{
    this.enable();
  }-*/;

}