package com.google.gwt.maps.utility.client.mapiconmaker;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * This class defines the options after which the icon is being built.
 */
public class MarkerIconOptions extends JavaScriptObject {

  public static native MarkerIconOptions newInstance() /*-{
    return {
      addStar: false,
      cornerColor: "#ffffff",
      height: 32,
      label: "",
      labelColor: "#000000",
      labelSize: 0,
      primaryColor: "#ff0000",
      shadowColor: "#000000",
      shape: "circle",
      starPrimaryColor: "#ffff00",
      starStrokeColor: "#000000",
      strokeColor: "#000000",
      width: 32
    };
  }-*/;

  protected MarkerIconOptions() {
  }

  /**
   * Whether to add a star to the edge of the icon.
   * The default value is false.
   * 
   * @return Whether to add a star to the edge of the icon.
   */
  public final native boolean getAddStar() /*-{
    return this.addStar;
  }-*/;

  /**
   * Retrieves, as a hexadecimal string, the color used for
   * the top corner of the icon. The default value is "#ffffff".
   * 
   * @return The color used for the top corner of the icon.
   */
  public final native String getCornerColor() /*-{
    return this.cornerColor;
  }-*/;

  /**
   * Retrieves, in pixels, the height of the icon. The default value is 32.
   * 
   * @return The height of the icon, in pixels.
   */
  public final native int getHeight() /*-{
    return this.height || 0;
  }-*/;

  /**
   * Retrieves a character or string to display inside the body of the icon.
   * Generally, one or two characters looks best. The default value is "".
   * 
   * @return A character or string to display inside the body of the icon.
   */
  public final native String getLabel() /*-{
    return this.label;
  }-*/;

  /**
   * Retrieves, as a hexadecimal string, the color used for the label text.
   * The default value is "#000000"
   * 
   * @return The color used for the label text.
   */
  public final native String getLabelColor() /*-{
    return this.labelColor;
  }-*/;

  /**
   * Retrieves, in pixels, the size of the label text.
   * If set to 0, the text auto-sizes to fit the icon body.
   * The default value is 0.
   * 
   * @return The size of the label text, in pixels.
   */
  public final native int getLabelSize() /*-{
    return this.labelSize;
  }-*/;

  /**
   * Retrieves, as a hexadecimal string, the color used for the
   * majority of the icon body. The default value is "#ff0000".
   * 
   * @return The color used for the majority of the icon body.
   */
  public final native String getPrimaryColor() /*-{
    return this.primaryColor;
  }-*/;

  /**
   * Retrieves, as a hexadecimal string, the color used for the shadow 
   * of the icon. The default value is "#000000".
   * 
   * @return The color used for the shadow of the icon.
   */
  public final native String getShadowColor() /*-{
    return this.shadowColor;
  }-*/;

  /**
   * Retrieves the shape of the icon. Current options are "circle" for a circle
   * or"roundrect" for a rounded rectangle. The default value is "circle".
   * 
   * @return The shape of the icon.
   */
  public final native String getShape() /*-{
    return this.shape;
  }-*/;

  /**
   * Retrieves, as a hexadecimal string, the color used for the star body.
   * The default value is "#FFFF00".
   * 
   * @return The color used for the star body.
   */
  public final native String getStarPrimaryColor() /*-{
    return this.starPrimaryColor;
  }-*/;

  /**
   * Retrieves, as a hexadecimal string, the color used for the outside line
   * (stroke) of the star. The default value is "#0000FF".
   * 
   * @return The color used for the outside line (stroke) of the star.
   */
  public final native String getStarStrokeColor() /*-{
    return this.starStrokeColor;
  }-*/;

  /**
   * Retrieves, as a hexadecimal string, the color used for the outside line
   * (stroke) of the icon. The default value is "#000000".
   * 
   * @return The color used for the outside line (stroke) of the icon.
   */
  public final native String getStrokeColor() /*-{
    return this.strokeColor;
  }-*/;

  /**
   * Retrieves, in pixels, the width of the icon. The width may include some
   * blank space on the side, depending on the height of the icon, as the
   * icon will scale its shape proportionately. The default value is 32.
   * 
   * @return The width of the icon, in pixels.
   */
  public final native int getWidth() /*-{
    return this.width || 0;
  }-*/;

  /**
   * Whether to add a star to the edge of the icon.
   * The default value is false.
   * 
   * @param addStar Whether to add a star to the edge of the icon.
   */
  public final native void setAddStar(boolean addStar) /*-{
    this.addStar = addStar;
  }-*/;

  /**
   * Specifies, as a hexadecimal string, the color used for
   * the top corner of the icon. The default value is "#ffffff".
   * 
   * @param cornerColor The color used for the top corner of the icon.
   */
  public final native void setCornerColor(String cornerColor) /*-{
    this.cornerColor = cornerColor;
  }-*/;

  /**
   * Specifies, in pixels, the height of the icon. The default value is 32.
   * 
   * @param height The height of the icon, in pixels.
   */
  public final native void setHeight(int height) /*-{
    this.height = height;
  }-*/;

  /**
   * Specifies a character or string to display inside the body of the icon.
   * Generally, one or two characters looks best. The default value is "".
   * 
   * @param label A character or string to display inside the body of the
   * icon.
   */
  public final native void setLabel(String label) /*-{
    this.label = label;
  }-*/;

  /**
   * Specifies, as a hexadecimal string, the color used for the label text.
   * The default value is "#000000"
   * 
   * @param labelColor The color used for the label text.
   */
  public final native void setLabelColor(String labelColor) /*-{
    this.labelColor = labelColor;
  }-*/;

  /**
   * Specifies, in pixels, the size of the label text.
   * If set to 0, the text auto-sizes to fit the icon body.
   * The default value is 0.
   * 
   * @param labelSize The size of the label text, in pixels.
   */
  public final native void setLabelSize(int labelSize) /*-{
    this.labelSize = labelSize;
  }-*/;

  /**
   * Specifies, as a hexadecimal string, the color used for the
   * majority of the icon body. The default value is "#ff0000".
   * 
   * @param primaryColor The color used for the majority of the icon body.
   */
  public final native void setPrimaryColor(String primaryColor) /*-{
    this.primaryColor = primaryColor;
  }-*/;

  /**
   * Specifies, as a hexadecimal string, the color used for the shadow
   * of the icon. The default value is "#000000".
   * 
   * @param shadowColor The color used for the shadow of the icon.
   */
  public final native void setShadowColor(String shadowColor) /*-{
    this.shadowColor = shadowColor;
  }-*/;

  /**
   * Specifies the shape of the icon. Current options are "circle" for a
   * circle or"roundrect" for a rounded rectangle. The default value is
   * "circle".
   * 
   * @param shape The shape of the icon.
   */
  public final native void setShape(String shape) /*-{
    this.shape = shape;
  }-*/;

  /**
   * Specifies, as a hexadecimal string, the color used for the star body.
   * The default value is "#FFFF00".
   * 
   * @param starPrimaryColor The color used for the star body.
   */
  public final native void setStarPrimaryColor(
      String starPrimaryColor) /*-{
    this.starPrimaryColor = starPrimaryColor;
  }-*/;

  /**
   * Specifies, as a hexadecimal string, the color used for the outside line
   * (stroke) of the star. The default value is "#0000FF".
   * 
   * @param starStrokeColor The color used for the outside line
   * (stroke) of the star.
   */
  public final native void setStarStrokeColor(
      String starStrokeColor) /*-{
    this.starStrokeColor = starStrokeColor;
  }-*/;

  /**
   * Specifies, as a hexadecimal string, the color used for the outside line
   * (stroke) of the icon. The default value is "#000000".
   * 
   * @param strokeColor The color used for the outside line (stroke) of
   * the icon.
   */
  public final native void setStrokeColor(String strokeColor) /*-{
    this.strokeColor = strokeColor;
  }-*/;

  /**
   * Specifies, in pixels, the width of the icon. The width may include some
   * blank space on the side, depending on the height of the icon, as the
   * icon will scale its shape proportionately. The default value is 32.
   * 
   * @param width The width of the icon, in pixels.
   */
  public final native void setWidth(int width) /*-{
    this.width = width;
  }-*/;
}
