/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.mapiconmaker;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.client.overlay.Icon;

/**
 * Provides functionality for creating dynamically sized and colored 
 * marker icons using the Charts API marker output.
 */
public class MapIconMaker extends JavaScriptObject {

  /**
   * Creates a flat icon based on the specified options in the
   * MarkerIconOption argument.
   * 
   * @param markerIconOptions The icon options.
   * @return the created icon
   */
  public static native Icon createFlatIcon(
      MarkerIconOptions markerIconOptions) /*-{
    return $wnd.MapIconMaker.createFlatIcon(markerIconOptions);
  }-*/;

  /**
   * Creates a labeled marker icon based on the specified options in the
   * MarkerIconOptions argument.
   * 
   * @param markerIconOptions The icon options
   * @return the created icon
   */
  public static native Icon createLabeledMarkerIcon(
      MarkerIconOptions markerIconOptions) /*-{
    return $wnd.MapIconMaker.createLabeledMarkerIcon(markerIconOptions);
  }-*/;

  /**
   * Creates an icon based on the specified options in the MarkerIconOptions
   * argument.
   * 
   * @param markerIconOptions The icon options.
   * @return the created icon
   */
  public static native Icon createMarkerIcon(
      MarkerIconOptions markerIconOptions) /*-{
    return $wnd.MapIconMaker.createMarkerIcon(markerIconOptions);
  }-*/;

  /**
   * JavaScriptObject require private or protected constructors.
   */
  protected MapIconMaker() {
  }
}
