/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.labeledmarker;

import com.google.gwt.maps.client.geom.LatLng;
import com.google.gwt.maps.client.overlay.Marker;
import com.google.gwt.maps.utility.client.impl.LabeledMarkerImpl;

/**
 * A labeled marker.
 */
public class LabeledMarker extends Marker {

  /**
   * Creates a marker at the specified position.
   * 
   * @param point The marker position.
   */
  public LabeledMarker(LatLng point) {
    super(LabeledMarkerImpl.newInstance(point));
  }

  /**
   * Creates a marker at the specified position, with the specified options.
   * 
   * @param point The marker position.
   * @param options The marker options.
   */
  public LabeledMarker(LatLng point, LabeledMarkerOptions options) {
    super(LabeledMarkerImpl.newInstance(point, options));
  }
  
  /**
   * Retrieves the label visibility.
   * 
   * @return The label visibility.
   */
  public boolean getLabelVisibility() {
    return ((LabeledMarkerImpl) this.jsoPeer).getLabelVisibility();
  }
  
  /**
   * Sets label text/html for the marker.
   * 
   * @param text The label text/html.
   */
  public void setLabelText(String text) {
    ((LabeledMarkerImpl) this.jsoPeer).setLabelText(text);
  }

  /**
   * Sets the label visibility.
   * 
   * @param visibility The label visibility.
   */
  public void setLabelVisibility(boolean visibility) {
    ((LabeledMarkerImpl) this.jsoPeer).setLabelVisibility(visibility);
  }
  
}