/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.utility.client.progressbarcontrol.ProgressbarOptions;

/**
 * The JavaScript implementation of ProgressbarControl.
 */
public class ProgressbarControlImpl extends JavaScriptObject {

  /**
   * Constructs a ProgressbarControl JavaScript object.
   * 
   * @param map The map in which to display the progress bar.
   * @return A ProgressbarControl JavaScript object.
   */
  public static native ProgressbarControlImpl newInstance(MapWidget map) /*-{
    return new $wnd.ProgressbarControl(
      map.@com.google.gwt.maps.client.MapWidget::getPeer()()
    );
  }-*/;

  /**
   * Constructs a ProgressbarControl JavaScript object at the
   * specified position.
   * 
   * @param map The map in which to display the progress bar.
   * @param options The progress bar options.
   * @return A ProgressbarControl JavaScript object.
   */
  public static native ProgressbarControlImpl newInstance(MapWidget map,
      ProgressbarOptions options) /*-{
    return new $wnd.ProgressbarControl(
      map.@com.google.gwt.maps.client.MapWidget::getPeer()(),
      options
    );
  }-*/;
  
  protected ProgressbarControlImpl() { }

  /**
   * Remove this progress bar control from the map.
   */
  public final native void remove() /*-{
    this.remove();
  }-*/;
  
  /**
   * Start the progress bar.
   * 
   * @param operations The maximum number of operations.
   */
  public final native void start(int operations) /*-{
    this.start(operations);
  }-*/;
  
  /**
   * Update the progress with specified number of operations.
   * 
   * @param step The number of completed operations.
   */
  public final native void updateLoader(int step) /*-{
    this.updateLoader(step);
  }-*/;
}
