/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.client.geom.LatLng;
import com.google.gwt.maps.utility.client.popupmarker.PopupMarkerOptions;

/**
 * The JavaScript implementation of PopupMarker.
 */
public class PopupMarkerImpl extends JavaScriptObject {

  /**
   * Constructs a PopupMarker JavaScript object at the specified position.
   * 
   * @param point The marker position.
   * @return A PopupMarker JavaScript object.
   */
  public static native PopupMarkerImpl newInstance(LatLng point) /*-{
    return new $wnd.PopupMarker(point);
  }-*/;

  /**
   * Constructs a PopupMarker JavaScript object at the specified position,
   * with the specified options.
   * 
   * @param point The marker position.
   * @param options The marker options.
   * @return A PopupMarker JavaScript object.
   */
  public static native PopupMarkerImpl newInstance(LatLng point, 
      PopupMarkerOptions options) /*-{
    return new $wnd.PopupMarker(point, options);
  }-*/;

  protected PopupMarkerImpl() { }
  
  /**
   * Hides the marker and popup.
   */
  public final native void hide() /*-{
    this.hide();
  }-*/;
  
  /**
   * Hides the popup.
   */
  public final native void hidePopup() /*-{
    this.hidePopup();
  }-*/;
  
  /**
   * Sets the background color. If the style property not set to "chart",
   * then this property is ignored.
   * 
   * @param bgColor The background color.
   */
  public final native void setChartBgColor(String bgColor) /*-{
    this.setChartBgColor(bgColor);
  }-*/;
  
  /**
   * Sets the icon name. If the style property not set to "chart", then this
   * property is ignored.
   * 
   * @param iconName The icon name.
   */
  public final native void setChartIcon(String iconName) /*-{
    this.setChartIcon(iconName);
  }-*/;
  
  /**
   * Sets the chart style. If the style property not set to "chart", then this
   * property is ignored.
   * 
   * @param styleName The chart style.
   */
  public final native void setChartStyle(String styleName) /*-{
    this.setChartStyle(styleName);
  }-*/;
  
  /**
   * Sets the chart text color. If the style property not set to "chart", then
   * this property is ignored.
   * 
   * @param textColor The text color.
   */
  public final native void setChartTextColor(String textColor) /*-{
    this.setChartTextColor(textColor);
  }-*/;
  
  /**
   * Set the text of the popup message.
   * 
   * @param message The popup message text.
   */
  public final native void setText(String message) /*-{
    this.setText(message);
  }-*/;
  
  /**
   * Shows the marker. Note that this method shows only the marker.
   * If you want to show marker and the popup, then use showPopup.
   */
  public final native void show() /*-{
    this.show();
  }-*/;
  
  /**
   * Shows the marker and the popup.
   */
  public final native void showPopup() /*-{
    this.showPopup();
  }-*/;

}