/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.overlay.Overlay;

/**
 * Provides utility methods for interacting with the Maps API and JSIO.
 */
public class MapsHelper {
  
  private static MapWidget mappy = getMappy();
  
  public static JavaScriptObject getOverlayPeer(Overlay overlay) {
    if (overlay == null) {
      return null;
    }
    mappy.addOverlay(overlay);
    return getOverlayPeer(mappy);
  }
  
  public static JsArray<JavaScriptObject> getOverlayPeers(Overlay[] overlays) {
    if (overlays == null) {
      return null;
    }
    JsArray<JavaScriptObject> peers = JsArray.createArray().cast();
    for (int i = 0; i < overlays.length; i++) {
      peers.set(i, getOverlayPeer(overlays[i]));
    }
    return peers;
  }

  private static MapWidget getMappy() {
    MapWidget map = new MapWidget();
    prepareMappy(map);
    return map;
  }
  
  private static native JavaScriptObject getOverlayPeer(MapWidget map) /*-{
    var jsMap = map.@com.google.gwt.maps.client.MapWidget::getPeer()();
    return jsMap._add_overlay_peer;
  }-*/;
  
  private static native void prepareMappy(MapWidget map) /*-{
    var jsMap = map.@com.google.gwt.maps.client.MapWidget::getPeer()();
    jsMap.addOverlay = function(o) {
      this._add_overlay_peer = o;
    }
  }-*/;
}