/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.client.geom.LatLng;
import com.google.gwt.maps.utility.client.labeledmarker.LabeledMarkerOptions;

/**
 * The JavaScript implementation of LabeledMarker.
 */
public class LabeledMarkerImpl extends JavaScriptObject {
  
  /**
   * Constructs a LabeledMarker JavaScript object at the specified position.
   * 
   * @param point The marker position.
   * @return A LabeledMarker JavaScript object.
   */
  public static native LabeledMarkerImpl newInstance(LatLng point) /*-{
    return new $wnd.LabeledMarker(point, {});
  }-*/;
  
  /**
   * Constructs a LabeledMarker JavaScript object at the specified position,
   * with the specified options.
   * 
   * @param point The marker position.
   * @param options The marker options.
   * @return A LabeledMarker JavaScript object.
   */
  public static native LabeledMarkerImpl newInstance(LatLng point, 
      LabeledMarkerOptions options) /*-{
    return new $wnd.LabeledMarker(point, options);
  }-*/;

  protected LabeledMarkerImpl() { }
  
  /**
   * Retrieves the label visibility.
   * 
   * @return The label visibility.
   */
  public final native boolean getLabelVisibility() /*-{
    return this.getLabelVisibility();
  }-*/;

  /**
   * Sets label text/html for the marker.
   * 
   * @param text The label text/html.
   */
  public final native void setLabelText(String text) /*-{
    this.setLabelText(text);
  }-*/;

  /**
   * Sets the label visibility.
   * 
   * @param visibility The label visibility.
   */
  public final native void setLabelVisibility(boolean visibility) /*-{
    this.setLabelVisibility(visibility);
  }-*/;
  
}