/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.maps.utility.client.contextmenucontrol.ContextMenuControlOptions;

/**
 * The JavaScript implementation of ContextMenuControl.
 */
public class ContextMenuControlImpl extends JavaScriptObject {

  /**
   * Constructs a ContextMenuControl JavaScript object.
   * 
   * @return A ContextMenuControl JavaScript object.
   */
  public static native ContextMenuControlImpl newInstance() /*-{
    return new $wnd.ContextMenuControl();
  }-*/;

  /**
   * Constructs a ContextMenuControl JavaScript object with
   * the specified options.
   * 
   * @param options The context menu options.
   * @return A ContextMenuControl JavaScript object.
   */
  public static native ContextMenuControlImpl newInstance(
      ContextMenuControlOptions options) /*-{
    return new $wnd.ContextMenuControl(options);
  }-*/;
  
  protected ContextMenuControlImpl() { }
}
