/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.contextmenucontrol;

import com.google.gwt.core.client.JavaScriptObject;

/**
 * Defines optional arguments to ContextMenuControl.
 */
public class ContextMenuControlOptions extends JavaScriptObject{

  /**
   * Constructs a ContextMenuControl options object.
   * 
   * @return A ContextMenuControlOptions object.
   */
  public static native ContextMenuControlOptions newInstance() /*-{
    return {
      centerMap: true,
      dirsFrom: true,
      dirsTo: true,
      whatsHere: true,
      zoomIn: true,
      zoomOut: true
    };
  }-*/;
  
  protected ContextMenuControlOptions() { }
  
  /**
   * Retrieves whether to display the "Center map here" option.
   * The default value is true.
   * 
   * @return Whether to display the "Center map here" option.
   */
  public final native boolean getShowCenterMap() /*-{
    return this.centerMap;
  }-*/;
  
  /**
   * Retrieves whether to display the "Directions from here" option.
   * The default value is true.
   * 
   * @return Whether to display the "Directions from here" option.
   */
  public final native boolean getShowDirectionsFrom() /*-{
    return this.dirsFrom;
  }-*/;
  
  /**
   * Retrieves whether to display the "Directions to here" option.
   * The default value is true.
   * 
   * @return Whether to display the "Directions to here" option.
   */
  public final native boolean getShowDirectionsTo() /*-{
    return this.dirsTo;
  }-*/;
  
  /**
   * Retrieves whether to display the "What's here?" option.
   * The default value is true.
   * 
   * @return Whether to display the "What's here?" option.
   */
  public final native boolean getShowWhatsHere() /*-{
    return this.whatsHere;
  }-*/;
  
  /**
   * Retrieves whether to display the "Zoom in" option.
   * The default value is true.
   * 
   * @return Whether to display the "Zoom in" option.
   */
  public final native boolean getShowZoomIn() /*-{
    return this.zoomIn;
  }-*/;
  
  /**
   * Retrieves whether to display the "Zoom out" option.
   * The default value is true.
   * 
   * @return Whether to display the "Zoom out" option.
   */
  public final native boolean getShowZoomOut() /*-{
    return this.zoomOut;
  }-*/;
  
  /**
   * Sets whether to display the "Center map here" option.
   * The default value is true.
   * 
   * @param centerMap Whether to display the "Center map here" option.
   */
  public final native void setShowCenterMap(boolean centerMap) /*-{
    this.centerMap = centerMap;
  }-*/;

  /**
   * Sets whether to display the "Directions to here" option.
   * The default value is true.
   * 
   * @param dirsFrom Whether to display the "Directions from here" option.
   */
  public final native void setShowDirectionsFrom(boolean dirsFrom) /*-{
    this.dirsFrom = dirsFrom;
  }-*/;

  /**
   * Sets whether to display the "Directions to here" option.
   * The default value is true.
   * 
   * @param dirsTo Whether to display the "Directions to here" option.
   */
  public final native void setShowDirectionsTo(boolean dirsTo) /*-{
    this.dirsTo = dirsTo;
  }-*/;

  /**
   * Sets whether to display the "What's here?" option.
   * The default value is true.
   * 
   * @param whatsHere Whether to display the "What's here?" option.
   */
  public final native void setShowWhatsHere(boolean whatsHere) /*-{
    this.whatsHere = whatsHere;
  }-*/;

  /**
   * Sets whether to display the "Zoom in" option.
   * The default value is true.
   * 
   * @param zoomIn Whether to display the "Zoom in" option.
   */
  public final native void setShowZoomIn(boolean zoomIn) /*-{
    this.zoomIn = zoomIn;
  }-*/;

  /**
   * Sets whether to display the "Zoom out" option.
   * The default value is true.
   * 
   * @param zoomOut Whether to display the "Zoom out" option.
   */
  public final native void setShowZoomOut(boolean zoomOut) /*-{
    this.zoomOut = zoomOut;
  }-*/;
  
}
