/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client.contextmenucontrol;

import com.google.gwt.maps.client.control.Control;
import com.google.gwt.maps.utility.client.impl.ContextMenuControlImpl;

/**
 * A control which mimics the context menu of Google Maps.
 */
public class ContextMenuControl extends Control {

  /**
   * Creates a context menu control.
   */
  public ContextMenuControl() {
    super(ContextMenuControlImpl.newInstance());
  }

  /**
   * Creates a context menu control with the specified options.
   * 
   * @param options The context menu options.
   */
  public ContextMenuControl(ContextMenuControlOptions options) {
    super(ContextMenuControlImpl.newInstance(options));
  }

}
