/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client;

/**
 * Represents a Google Maps Utility package.
 */
public interface GoogleMapsUtilityPackage {
  
  /**
   * Retrieves the top-level object that indicates the availability of the
   * package.
   * 
   * @return The package indicator.
   */
  String getIndicator();
  
  /**
   * Retrieves the script source url for the package.
   * 
   * @return The package's script source.
   */
  String getSource();
  
  /**
   * Retrieves the version of the package.
   * 
   * @return The package's version.
   */
  String getVersion();
  
}
