/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.maps.utility.client;

/**
 * Represents the default Google Maps utility packages.
 */
public enum DefaultPackage implements GoogleMapsUtilityPackage {

  CONTEXT_MENU_CONTROL("1.0", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/contextmenucontrol/1.0/src/contextmenucontrol_packed.js", "ContextMenuControl"),
  LABELED_MARKER("1.4", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/labeledmarker/1.4/src/labeledmarker_packed.js", "LabeledMarker"),
  MAP_ICON_MAKER("1.1", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/mapiconmaker/1.1/src/mapiconmaker_packed.js", "MapIconMaker"),
  MARKER_CLUSTERER("1.0", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/markerclusterer/1.0/src/markerclusterer_packed.js", "MarkerClusterer"),
  MARKER_MANAGER("1.1", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/markermanager/1.1/src/markermanager_packed.js", "MarkerManager"),
  MARKER_TRACKER("1.0", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/markertracker/1.1/src/markertracker_packed.js", "MarkerTracker"),
  POPUP_MARKER("1.1", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/popupmarker/1.1/src/popupmarker_packed.js", "PopupMarker"),
  PROGRESS_BAR_CONTROL("1.0", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/progressbarcontrol/1.0/src/progressbarcontrol_packed.js", "ProgressbarControl"),
  SNAPSHOT_CONTROL("1.0", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/snapshotcontrol/1.0/src/snapshotcontrol_packed.js", "SnapShotControl"),
  SNAP_TO_ROUTE("1.0", "http://gmaps-utility-library-dev.googlecode.com/svn/tags/snaptoroute/1.0/src/snaptoroute_packed.js", "SnapToRoute"),
  ;
  
  private String version, source, indicator;
  private DefaultPackage(String version, String source, String indicator) {
    this.version = version;
    this.source = source;
    this.indicator = indicator;
  }

  /**
   * Retrieves the top-level object that indicates the availability of the
   * package.
   * 
   * @return The package indicator.
   */
  public String getIndicator() {
    return indicator;
  }

  /**
   * Retrieves the script source url for the package.
   * 
   * @return The package's script source.
   */
  public String getSource() {
    return source;
  }

  /**
   * Retrieves the version of the package.
   * 
   * @return The package's version.
   */
  public String getVersion() {
    return version;
  }
  
}
