/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent.test;

import java.util.GregorianCalendar;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.agentx.subagent.AgentXSharedMOTableSupport;
import org.snmp4j.agent.agentx.subagent.DefaultAgentXSharedMOTable;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.DateAndTime;
import org.snmp4j.agent.mo.snmp.smi.Constraint;
import org.snmp4j.agent.mo.snmp.smi.ConstraintsImpl;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraint;
import org.snmp4j.agent.mo.snmp.smi.ValueConstraintValidator;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public class AgentppTestMib
implements MOGroup {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentppTestMib.class);
    private MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidAgentppTestTimeout = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 6, 3, 1, 1, 0});
    private MOScalar agentppTestTimeout;
    public static final OID oidAgentppTestSharedEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 6, 3, 1, 3, 1});
    public static final OID oidAgentppTestSharedTableIndex = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 6, 3, 1, 3, 1, 1});
    public static final String tcModuleSNMPv2Tc = "SNMPv2-TC";
    public static final String tcDefDateAndTime = "DateAndTime";
    public static final String tcDefRowStatus = "RowStatus";
    public static final int colAgentppTestSharedTableCreationTime = 2;
    public static final int colAgentppTestSharedTableDelay = 3;
    public static final int colAgentppTestSharedTableSession = 4;
    public static final int colAgentppTestSharedTableRowStatus = 5;
    public static final int idxAgentppTestSharedTableCreationTime = 0;
    public static final int idxAgentppTestSharedTableDelay = 1;
    public static final int idxAgentppTestSharedTableSession = 2;
    public static final int idxAgentppTestSharedTableRowStatus = 3;
    private MOTableSubIndex[] agentppTestSharedEntryIndexes;
    private MOTableIndex agentppTestSharedEntryIndex;
    private MOTable<AgentppTestSharedEntryRow, MOColumn, MOMutableTableModel<AgentppTestSharedEntryRow>> agentppTestSharedEntry;
    private MOTableModel<AgentppTestSharedEntryRow> agentppTestSharedEntryModel;
    public static final OID oidAgentppTestSessionsEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 6, 3, 1, 4, 1});
    public static final OID oidAgentppTestSessionIndex = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 6, 3, 1, 4, 1, 1});
    public static final int colAgentppTestRowCreation = 2;
    public static final int idxAgentppTestRowCreation = 0;
    private MOTableSubIndex[] agentppTestSessionsEntryIndexes;
    private MOTableIndex agentppTestSessionsEntryIndex;
    private MOTable agentppTestSessionsEntry;
    private MOTableModel agentppTestSessionsEntryModel;
    public static final OID oidAgentppTestSparseEntry = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 6, 3, 1, 5, 1});
    public static final OID oidAgentppTestSparseIndex = new OID(new int[]{1, 3, 6, 1, 4, 1, 4976, 6, 3, 1, 5, 1, 1});
    public static final int colAgentppTestSparseCol1 = 2;
    public static final int colAgentppTestSparseCol2 = 3;
    public static final int colAgentppTestSparseCol3 = 4;
    public static final int colAgentppTestSparseRowStatus = 5;
    public static final int idxAgentppTestSparseCol1 = 0;
    public static final int idxAgentppTestSparseCol2 = 1;
    public static final int idxAgentppTestSparseCol3 = 2;
    public static final int idxAgentppTestSparseRowStatus = 3;
    private MOTableSubIndex[] agentppTestSparseEntryIndexes;
    private MOTableIndex agentppTestSparseEntryIndex;
    private MOTable agentppTestSparseEntry;
    private MOTableModel agentppTestSparseEntryModel;

    protected AgentppTestMib() {
    }

    public AgentppTestMib(MOFactory moFactory) {
        this.createMO(moFactory);
    }

    protected void createMO(MOFactory moFactory) {
        this.agentppTestTimeout = new AgentppTestTimeout(oidAgentppTestTimeout, moFactory.createAccess(11));
        this.agentppTestTimeout.addMOValueValidationListener((MOValueValidationListener)new AgentppTestTimeoutValidator());
        this.createAgentppTestSharedEntry(moFactory);
        this.createAgentppTestSessionsEntry(moFactory);
        this.createAgentppTestSparseEntry(moFactory);
    }

    public MOTable getAgentppTestSharedEntry() {
        return this.agentppTestSharedEntry;
    }

    private void createAgentppTestSharedEntry(MOFactory moFactory) {
        this.agentppTestSharedEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidAgentppTestSharedTableIndex, 2, 1, 1)};
        this.agentppTestSharedEntryIndex = moFactory.createIndex(this.agentppTestSharedEntryIndexes, false, new MOTableIndexValidator(){

            public boolean isValidIndex(OID index) {
                boolean isValidIndex = true;
                return isValidIndex;
            }
        });
        MOColumn[] agentppTestSharedEntryColumns = new MOColumn[4];
        agentppTestSharedEntryColumns[0] = moFactory.createColumn(2, 4, moFactory.createAccess(9), tcModuleSNMPv2Tc, tcDefDateAndTime);
        agentppTestSharedEntryColumns[1] = moFactory.createColumn(3, 2, moFactory.createAccess(15), (Variable)new Integer32(0), true);
        ConstraintsImpl agentppTestSharedTableDelayVC = new ConstraintsImpl();
        agentppTestSharedTableDelayVC.add(new Constraint(0L, 6000L));
        ((MOMutableColumn)agentppTestSharedEntryColumns[1]).addMOValueValidationListener((MOValueValidationListener)new ValueConstraintValidator((ValueConstraint)agentppTestSharedTableDelayVC));
        ((MOMutableColumn)agentppTestSharedEntryColumns[1]).addMOValueValidationListener((MOValueValidationListener)new AgentppTestSharedTableDelayValidator());
        agentppTestSharedEntryColumns[2] = moFactory.createColumn(4, 66, moFactory.createAccess(9));
        agentppTestSharedEntryColumns[3] = moFactory.createColumn(5, 2, moFactory.createAccess(15), tcModuleSNMPv2Tc, tcDefRowStatus);
        ((MOMutableColumn)agentppTestSharedEntryColumns[3]).addMOValueValidationListener((MOValueValidationListener)new AgentppTestSharedTableRowStatusValidator());
        this.agentppTestSharedEntryModel = moFactory.createTableModel(oidAgentppTestSharedEntry, this.agentppTestSharedEntryIndex, agentppTestSharedEntryColumns);
        ((MOMutableTableModel)this.agentppTestSharedEntryModel).setRowFactory((MOTableRowFactory)new AgentppTestSharedEntryRowFactory());
        this.agentppTestSharedEntry = moFactory.createTable(oidAgentppTestSharedEntry, this.agentppTestSharedEntryIndex, agentppTestSharedEntryColumns, this.agentppTestSharedEntryModel);
    }

    public MOTable getAgentppTestSessionsEntry() {
        return this.agentppTestSessionsEntry;
    }

    private void createAgentppTestSessionsEntry(MOFactory moFactory) {
        this.agentppTestSessionsEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidAgentppTestSessionIndex, 2, 1, 1)};
        this.agentppTestSessionsEntryIndex = moFactory.createIndex(this.agentppTestSessionsEntryIndexes, false, new MOTableIndexValidator(){

            public boolean isValidIndex(OID index) {
                boolean isValidIndex = true;
                return isValidIndex;
            }
        });
        MOColumn[] agentppTestSessionsEntryColumns = new MOColumn[]{moFactory.createColumn(2, 66, moFactory.createAccess(11), (Variable)new UnsignedInteger32(0), true)};
        ((MOMutableColumn)agentppTestSessionsEntryColumns[0]).addMOValueValidationListener((MOValueValidationListener)new AgentppTestRowCreationValidator());
        this.agentppTestSessionsEntryModel = moFactory.createTableModel(oidAgentppTestSessionsEntry, this.agentppTestSessionsEntryIndex, agentppTestSessionsEntryColumns);
        ((MOMutableTableModel)this.agentppTestSessionsEntryModel).setRowFactory((MOTableRowFactory)new AgentppTestSessionsEntryRowFactory());
        this.agentppTestSessionsEntry = moFactory.createTable(oidAgentppTestSessionsEntry, this.agentppTestSessionsEntryIndex, agentppTestSessionsEntryColumns, this.agentppTestSessionsEntryModel);
    }

    public MOTable getAgentppTestSparseEntry() {
        return this.agentppTestSparseEntry;
    }

    private void createAgentppTestSparseEntry(MOFactory moFactory) {
        this.agentppTestSparseEntryIndexes = new MOTableSubIndex[]{moFactory.createSubIndex(oidAgentppTestSparseIndex, 4, 0, 255)};
        this.agentppTestSparseEntryIndex = moFactory.createIndex(this.agentppTestSparseEntryIndexes, false, null);
        MOColumn[] agentppTestSparseEntryColumns = new MOColumn[4];
        agentppTestSparseEntryColumns[0] = moFactory.createColumn(2, 2, moFactory.createAccess(15), (Variable)new Integer32(1), true);
        ((MOMutableColumn)agentppTestSparseEntryColumns[0]).addMOValueValidationListener((MOValueValidationListener)new AgentppTestSparseCol1Validator());
        agentppTestSparseEntryColumns[1] = moFactory.createColumn(3, 66, moFactory.createAccess(15), (Variable)new Gauge32(2L), true);
        ((MOMutableColumn)agentppTestSparseEntryColumns[1]).addMOValueValidationListener((MOValueValidationListener)new AgentppTestSparseCol2Validator());
        agentppTestSparseEntryColumns[2] = moFactory.createColumn(4, 4, moFactory.createAccess(15), (Variable)new OctetString(new byte[]{51}), true);
        ConstraintsImpl agentppTestSparseCol3VC = new ConstraintsImpl();
        agentppTestSparseCol3VC.add(new Constraint(0L, 255L));
        ((MOMutableColumn)agentppTestSparseEntryColumns[2]).addMOValueValidationListener((MOValueValidationListener)new ValueConstraintValidator((ValueConstraint)agentppTestSparseCol3VC));
        ((MOMutableColumn)agentppTestSparseEntryColumns[2]).addMOValueValidationListener((MOValueValidationListener)new AgentppTestSparseCol3Validator());
        agentppTestSparseEntryColumns[3] = moFactory.createColumn(5, 2, moFactory.createAccess(15), tcModuleSNMPv2Tc, tcDefRowStatus);
        ((MOMutableColumn)agentppTestSparseEntryColumns[3]).addMOValueValidationListener((MOValueValidationListener)new AgentppTestSparseRowStatusValidator());
        this.agentppTestSparseEntryModel = moFactory.createTableModel(oidAgentppTestSparseEntry, this.agentppTestSparseEntryIndex, agentppTestSparseEntryColumns);
        ((MOMutableTableModel)this.agentppTestSparseEntryModel).setRowFactory((MOTableRowFactory)new AgentppTestSparseEntryRowFactory());
        this.agentppTestSparseEntry = moFactory.createTable(oidAgentppTestSparseEntry, this.agentppTestSparseEntryIndex, agentppTestSparseEntryColumns, this.agentppTestSparseEntryModel);
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.agentppTestTimeout, context);
        server.register(this.agentppTestSharedEntry, context);
        server.register((ManagedObject)this.agentppTestSessionsEntry, context);
        server.register((ManagedObject)this.agentppTestSparseEntry, context);
        for (int i = 0; i < 10; ++i) {
            Variable[] vbs = this.agentppTestSparseEntry.getDefaultValues();
            vbs[3] = new Integer32(1);
            MOTableRow row = this.agentppTestSparseEntry.createRow(new OID(new int[]{1, 48 + i}), vbs);
            this.agentppTestSparseEntry.addRow(row);
        }
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.agentppTestTimeout, context);
        server.unregister(this.agentppTestSharedEntry, context);
        server.unregister((ManagedObject)this.agentppTestSessionsEntry, context);
        server.unregister((ManagedObject)this.agentppTestSparseEntry, context);
    }

    public static MOFactory getSharedTableFactory() {
        return new AgentppTestMOFactory();
    }

    static class AgentppTestMOFactory
    extends DefaultMOFactory {
        AgentppTestMOFactory() {
        }

        public MOTable createTable(OID oid, MOTableIndex indexDef, MOColumn[] columns) {
            if (oidAgentppTestSessionsEntry.equals((Object)oid)) {
                return new DefaultAgentXSharedMOTable(oid, indexDef, columns){

                    @Override
                    public void setAgentXSharedMOTableSupport(AgentXSharedMOTableSupport sharedTableSupport) {
                        super.setAgentXSharedMOTableSupport(sharedTableSupport);
                        ((MOMutableTableModel)this.model).clear();
                        OID index = new OID(new int[]{sharedTableSupport.getSession().getSessionID()});
                        MOTableRow row = this.createRow(index);
                        if (row != null) {
                            this.addRow(row);
                        }
                    }
                };
            }
            return new DefaultAgentXSharedMOTable(oid, indexDef, columns);
        }

        public MOTable createTable(OID oid, MOTableIndex indexDef, MOColumn[] columns, MOTableModel model) {
            DefaultAgentXSharedMOTable table = (DefaultAgentXSharedMOTable)this.createTable(oid, indexDef, columns);
            table.setModel(model);
            return table;
        }
    }

    class AgentppTestSparseEntryRowFactory
    extends DefaultMOMutableRow2PCFactory<AgentppTestSparseEntryRow> {
        AgentppTestSparseEntryRowFactory() {
        }

        public synchronized AgentppTestSparseEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            AgentppTestSparseEntryRow row = new AgentppTestSparseEntryRow(index, values);
            return row;
        }

        public synchronized void freeRow(AgentppTestSparseEntryRow row) {
        }
    }

    public class AgentppTestSparseEntryRow
    extends DefaultMOMutableRow2PC {
        public AgentppTestSparseEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public Integer32 getAgentppTestSparseCol1() {
            return (Integer32)this.getValue(0);
        }

        public void setAgentppTestSparseCol1(Integer32 newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public Gauge32 getAgentppTestSparseCol2() {
            return (Gauge32)this.getValue(1);
        }

        public void setAgentppTestSparseCol2(Gauge32 newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public OctetString getAgentppTestSparseCol3() {
            return (OctetString)this.getValue(2);
        }

        public void setAgentppTestSparseCol3(OctetString newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public Integer32 getAgentppTestSparseRowStatus() {
            return (Integer32)this.getValue(3);
        }

        public void setAgentppTestSparseRowStatus(Integer32 newValue) {
            this.setValue(3, (Variable)newValue);
        }

        public void setValue(int column, Variable value) {
            if (column != 3 && value.equals(this.getValue(column))) {
                super.setValue(column, null);
                return;
            }
            super.setValue(column, value);
        }
    }

    class AgentppTestSessionsEntryRowFactory
    extends DefaultMOMutableRow2PCFactory<AgentppTestSessionsEntryRow> {
        AgentppTestSessionsEntryRowFactory() {
        }

        public synchronized AgentppTestSessionsEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            AgentppTestSessionsEntryRow row = new AgentppTestSessionsEntryRow(index, values);
            return row;
        }

        public synchronized void freeRow(AgentppTestSessionsEntryRow row) {
        }
    }

    public class AgentppTestSessionsEntryRow
    extends DefaultMOMutableRow2PC {
        public AgentppTestSessionsEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public UnsignedInteger32 getAgentppTestRowCreation() {
            return (UnsignedInteger32)this.getValue(0);
        }

        public void setAgentppTestRowCreation(UnsignedInteger32 newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public void commitRow(SubRequest subRequest, MOTableRow changeSet) {
            int newRowIndex = changeSet.getValue(0).toInt();
            if (newRowIndex != 0) {
                OID newIndex = new OID(new int[]{newRowIndex});
                Variable[] values = AgentppTestMib.this.agentppTestSharedEntry.getDefaultValues();
                values[3] = new Integer32(1);
                values[0] = DateAndTime.makeDateAndTime((GregorianCalendar)new GregorianCalendar());
                values[2] = new UnsignedInteger32(this.getIndex().get(0));
                AgentppTestSharedEntryRow row = (AgentppTestSharedEntryRow)AgentppTestMib.this.agentppTestSharedEntry.createRow(newIndex, values);
                if (row != null) {
                    if (!AgentppTestMib.this.agentppTestSharedEntry.addRow((MOTableRow)row)) {
                        ((UnsignedInteger32)changeSet.getValue(0)).setValue(0L);
                    }
                } else {
                    ((UnsignedInteger32)changeSet.getValue(0)).setValue(0L);
                }
            }
        }
    }

    class AgentppTestSharedEntryRowFactory
    extends DefaultMOMutableRow2PCFactory<AgentppTestSharedEntryRow> {
        AgentppTestSharedEntryRowFactory() {
        }

        public synchronized AgentppTestSharedEntryRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
            AgentppTestSharedEntryRow row = new AgentppTestSharedEntryRow(index, values);
            return row;
        }

        public synchronized void freeRow(AgentppTestSharedEntryRow row) {
        }
    }

    public class AgentppTestSharedEntryRow
    extends DefaultMOMutableRow2PC {
        public AgentppTestSharedEntryRow(OID index, Variable[] values) {
            super(index, values);
        }

        public OctetString getAgentppTestSharedTableCreationTime() {
            return (OctetString)this.getValue(0);
        }

        public void setAgentppTestSharedTableCreationTime(OctetString newValue) {
            this.setValue(0, (Variable)newValue);
        }

        public Integer32 getAgentppTestSharedTableDelay() {
            return (Integer32)this.getValue(1);
        }

        public void setAgentppTestSharedTableDelay(Integer32 newValue) {
            this.setValue(1, (Variable)newValue);
        }

        public UnsignedInteger32 getAgentppTestSharedTableSession() {
            return (UnsignedInteger32)this.getValue(2);
        }

        public void setAgentppTestSharedTableSession(UnsignedInteger32 newValue) {
            this.setValue(2, (Variable)newValue);
        }

        public Integer32 getAgentppTestSharedTableRowStatus() {
            return (Integer32)this.getValue(3);
        }

        public void setAgentppTestSharedTableRowStatus(Integer32 newValue) {
            this.setValue(3, (Variable)newValue);
        }

        private void delayRequest() {
            long delay = this.values[1].toInt() * 10;
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public Variable getValue(int column) {
            this.delayRequest();
            return super.getValue(column);
        }

        public void commit(SubRequest subRequest, MOTableRow changeSet, int column) {
            this.delayRequest();
            super.commit(subRequest, changeSet, column);
        }
    }

    static class AgentppTestSparseRowStatusValidator
    implements MOValueValidationListener {
        AgentppTestSparseRowStatusValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class AgentppTestSparseCol3Validator
    implements MOValueValidationListener {
        AgentppTestSparseCol3Validator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            OctetString os = (OctetString)newValue;
            if (os.length() < 0 || os.length() > 255) {
                validationEvent.setValidationStatus(8);
                return;
            }
        }
    }

    static class AgentppTestSparseCol2Validator
    implements MOValueValidationListener {
        AgentppTestSparseCol2Validator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class AgentppTestSparseCol1Validator
    implements MOValueValidationListener {
        AgentppTestSparseCol1Validator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class AgentppTestRowCreationValidator
    implements MOValueValidationListener {
        AgentppTestRowCreationValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class AgentppTestSharedTableRowStatusValidator
    implements MOValueValidationListener {
        AgentppTestSharedTableRowStatusValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }

    static class AgentppTestSharedTableDelayValidator
    implements MOValueValidationListener {
        AgentppTestSharedTableDelayValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            long v = ((Integer32)newValue).getValue();
            if (v < 0L || v > 6000L) {
                validationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    static class AgentppTestTimeoutValidator
    implements MOValueValidationListener {
        AgentppTestTimeoutValidator() {
        }

        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
            long v = ((UnsignedInteger32)newValue).getValue();
            if (v < 0L || v > 1000000L) {
                validationEvent.setValidationStatus(10);
                return;
            }
        }
    }

    public class AgentppTestTimeout
    extends MOScalar {
        AgentppTestTimeout(OID oid, MOAccess access) {
            super(oid, access, (Variable)new UnsignedInteger32());
        }

        public int isValueOK(SubRequest request) {
            Variable newValue = request.getVariableBinding().getVariable();
            int valueOK = super.isValueOK(request);
            if (valueOK != 0) {
                return valueOK;
            }
            long v = ((UnsignedInteger32)newValue).getValue();
            if (v < 0L || v > 1000000L) {
                valueOK = 10;
            }
            return valueOK;
        }

        public Variable getValue() {
            return super.getValue();
        }

        public int setValue(Variable newValue) {
            return super.setValue(newValue);
        }
    }
}

