/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.smi.VariableBinding;

public class AgentXResponsePDU
extends AgentXPDU {
    private int sysUpTime;
    private short errorStatus;
    private short errorIndex;
    private List variableBindings = new ArrayList();

    public AgentXResponsePDU(int sysUpTime, short errorStatus, short errorIndex) {
        super((byte)18);
        this.sysUpTime = sysUpTime;
        this.errorIndex = errorIndex;
        this.errorStatus = errorStatus;
    }

    public AgentXResponsePDU(AgentXMessageHeader header) {
        super(header);
    }

    @Override
    public void decodePayload(ByteBuffer buf, int length) throws IOException {
        this.sysUpTime = buf.getInt();
        this.errorStatus = buf.getShort();
        this.errorIndex = buf.getShort();
        this.variableBindings = Arrays.asList(AgentXProtocol.decodeVariableBindings(buf));
    }

    @Override
    protected void encodePayload(ByteBuffer buf) {
        buf.putInt(this.sysUpTime);
        buf.putShort(this.errorStatus);
        buf.putShort(this.errorIndex);
        AgentXProtocol.encodeVaribleBindings(buf, this.getVariableBindings());
    }

    @Override
    public int getPayloadLength() {
        return 8 + AgentXProtocol.getVariableBindingsLength(this.getVariableBindings());
    }

    public int getSysUpTime() {
        return this.sysUpTime;
    }

    public VariableBinding[] getVariableBindings() {
        VariableBinding[] vbs = this.variableBindings.toArray(new VariableBinding[this.variableBindings.size()]);
        return vbs;
    }

    public int size() {
        return this.variableBindings.size();
    }

    public short getErrorIndex() {
        return this.errorIndex;
    }

    public short getErrorStatus() {
        return this.errorStatus;
    }

    public void setVariableBindings(VariableBinding[] variableBindings) {
        this.variableBindings = Arrays.asList(variableBindings);
    }

    public void setSysUpTime(int sysUpTime) {
        this.sysUpTime = sysUpTime;
    }

    public void setErrorStatus(short errorStatus) {
        this.errorStatus = errorStatus;
    }

    public void setErrorIndex(short errorIndex) {
        this.errorIndex = errorIndex;
    }

    public void setErrorStatus(int errorStatus) {
        this.errorStatus = (short)errorStatus;
    }

    public void setErrorIndex(int errorIndex) {
        this.errorIndex = (short)errorIndex;
    }

    public void add(VariableBinding vb) {
        this.variableBindings.add(vb);
    }

    public void clear() {
        this.variableBindings.clear();
    }

    @Override
    protected void beforeEncode() {
    }

    @Override
    protected String toStringExtMembers() {
        return super.toStringExtMembers() + ",sysUpTime=" + this.sysUpTime + ",errorStatus=" + this.errorStatus + ",errorIndex=" + this.errorIndex + ",vbs=" + this.variableBindings;
    }
}

